/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.res.Resources;
import android.telephony.Rlog;
import android.text.TextUtils;
import android.util.SparseIntArray;
import com.android.internal.telephony.EncodeException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class GsmAlphabet {
    public static final byte GSM_EXTENDED_ESCAPE = 27;
    private static final String TAG = "GSM";
    public static final int UDH_SEPTET_COST_CONCATENATED_MESSAGE = 6;
    public static final int UDH_SEPTET_COST_LENGTH = 1;
    public static final int UDH_SEPTET_COST_ONE_SHIFT_TABLE = 4;
    public static final int UDH_SEPTET_COST_TWO_SHIFT_TABLES = 7;
    private static final SparseIntArray[] sCharsToGsmTables;
    private static final SparseIntArray[] sCharsToShiftTables;
    private static boolean sDisableCountryEncodingCheck;
    private static int[] sEnabledLockingShiftTables;
    private static int[] sEnabledSingleShiftTables;
    private static int sHighestEnabledSingleShiftCode;
    private static final String[] sLanguageShiftTables;
    private static final String[] sLanguageTables;

    static {
        sDisableCountryEncodingCheck = false;
        sLanguageTables = new String[]{"@\u00a3$\u00a5\u00e8\u00e9\u00f9\u00ec\u00f2\u00c7\n\u00d8\u00f8\r\u00c5\u00e5\u0394_\u03a6\u0393\u039b\u03a9\u03a0\u03a8\u03a3\u0398\u039e\uffff\u00c6\u00e6\u00df\u00c9 !\"#\u00a4%&'()*+,-./0123456789:;<=>?\u00a1ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00d1\u00dc\u00a7\u00bfabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00f1\u00fc\u00e0", "@\u00a3$\u00a5\u20ac\u00e9\u00f9\u0131\u00f2\u00c7\n\u011e\u011f\r\u00c5\u00e5\u0394_\u03a6\u0393\u039b\u03a9\u03a0\u03a8\u03a3\u0398\u039e\uffff\u015e\u015f\u00df\u00c9 !\"#\u00a4%&'()*+,-./0123456789:;<=>?\u0130ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00d1\u00dc\u00a7\u00e7abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00f1\u00fc\u00e0", "", "@\u00a3$\u00a5\u00ea\u00e9\u00fa\u00ed\u00f3\u00e7\n\u00d4\u00f4\r\u00c1\u00e1\u0394_\u00aa\u00c7\u00c0\u221e^\\\u20ac\u00d3|\uffff\u00c2\u00e2\u00ca\u00c9 !\"#\u00ba%&'()*+,-./0123456789:;<=>?\u00cdABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c3\u00d5\u00da\u00dc\u00a7~abcdefghijklmnopqrstuvwxyz\u00e3\u00f5`\u00fc\u00e0", "\u0981\u0982\u0983\u0985\u0986\u0987\u0988\u0989\u098a\u098b\n\u098c \r \u098f\u0990  \u0993\u0994\u0995\u0996\u0997\u0998\u0999\u099a\uffff\u099b\u099c\u099d\u099e !\u099f\u09a0\u09a1\u09a2\u09a3\u09a4)(\u09a5\u09a6,\u09a7.\u09a80123456789:; \u09aa\u09ab?\u09ac\u09ad\u09ae\u09af\u09b0 \u09b2   \u09b6\u09b7\u09b8\u09b9\u09bc\u09bd\u09be\u09bf\u09c0\u09c1\u09c2\u09c3\u09c4  \u09c7\u09c8  \u09cb\u09cc\u09cd\u09ceabcdefghijklmnopqrstuvwxyz\u09d7\u09dc\u09dd\u09f0\u09f1", "\u0a81\u0a82\u0a83\u0a85\u0a86\u0a87\u0a88\u0a89\u0a8a\u0a8b\n\u0a8c\u0a8d\r \u0a8f\u0a90\u0a91 \u0a93\u0a94\u0a95\u0a96\u0a97\u0a98\u0a99\u0a9a\uffff\u0a9b\u0a9c\u0a9d\u0a9e !\u0a9f\u0aa0\u0aa1\u0aa2\u0aa3\u0aa4)(\u0aa5\u0aa6,\u0aa7.\u0aa80123456789:; \u0aaa\u0aab?\u0aac\u0aad\u0aae\u0aaf\u0ab0 \u0ab2\u0ab3 \u0ab5\u0ab6\u0ab7\u0ab8\u0ab9\u0abc\u0abd\u0abe\u0abf\u0ac0\u0ac1\u0ac2\u0ac3\u0ac4\u0ac5 \u0ac7\u0ac8\u0ac9 \u0acb\u0acc\u0acd\u0ad0abcdefghijklmnopqrstuvwxyz\u0ae0\u0ae1\u0ae2\u0ae3\u0af1", "\u0901\u0902\u0903\u0905\u0906\u0907\u0908\u0909\u090a\u090b\n\u090c\u090d\r\u090e\u090f\u0910\u0911\u0912\u0913\u0914\u0915\u0916\u0917\u0918\u0919\u091a\uffff\u091b\u091c\u091d\u091e !\u091f\u0920\u0921\u0922\u0923\u0924)(\u0925\u0926,\u0927.\u09280123456789:;\u0929\u092a\u092b?\u092c\u092d\u092e\u092f\u0930\u0931\u0932\u0933\u0934\u0935\u0936\u0937\u0938\u0939\u093c\u093d\u093e\u093f\u0940\u0941\u0942\u0943\u0944\u0945\u0946\u0947\u0948\u0949\u094a\u094b\u094c\u094d\u0950abcdefghijklmnopqrstuvwxyz\u0972\u097b\u097c\u097e\u097f", " \u0c82\u0c83\u0c85\u0c86\u0c87\u0c88\u0c89\u0c8a\u0c8b\n\u0c8c \r\u0c8e\u0c8f\u0c90 \u0c92\u0c93\u0c94\u0c95\u0c96\u0c97\u0c98\u0c99\u0c9a\uffff\u0c9b\u0c9c\u0c9d\u0c9e !\u0c9f\u0ca0\u0ca1\u0ca2\u0ca3\u0ca4)(\u0ca5\u0ca6,\u0ca7.\u0ca80123456789:; \u0caa\u0cab?\u0cac\u0cad\u0cae\u0caf\u0cb0\u0cb1\u0cb2\u0cb3 \u0cb5\u0cb6\u0cb7\u0cb8\u0cb9\u0cbc\u0cbd\u0cbe\u0cbf\u0cc0\u0cc1\u0cc2\u0cc3\u0cc4 \u0cc6\u0cc7\u0cc8 \u0cca\u0ccb\u0ccc\u0ccd\u0cd5abcdefghijklmnopqrstuvwxyz\u0cd6\u0ce0\u0ce1\u0ce2\u0ce3", " \u0d02\u0d03\u0d05\u0d06\u0d07\u0d08\u0d09\u0d0a\u0d0b\n\u0d0c \r\u0d0e\u0d0f\u0d10 \u0d12\u0d13\u0d14\u0d15\u0d16\u0d17\u0d18\u0d19\u0d1a\uffff\u0d1b\u0d1c\u0d1d\u0d1e !\u0d1f\u0d20\u0d21\u0d22\u0d23\u0d24)(\u0d25\u0d26,\u0d27.\u0d280123456789:; \u0d2a\u0d2b?\u0d2c\u0d2d\u0d2e\u0d2f\u0d30\u0d31\u0d32\u0d33\u0d34\u0d35\u0d36\u0d37\u0d38\u0d39 \u0d3d\u0d3e\u0d3f\u0d40\u0d41\u0d42\u0d43\u0d44 \u0d46\u0d47\u0d48 \u0d4a\u0d4b\u0d4c\u0d4d\u0d57abcdefghijklmnopqrstuvwxyz\u0d60\u0d61\u0d62\u0d63\u0d79", "\u0b01\u0b02\u0b03\u0b05\u0b06\u0b07\u0b08\u0b09\u0b0a\u0b0b\n\u0b0c \r \u0b0f\u0b10  \u0b13\u0b14\u0b15\u0b16\u0b17\u0b18\u0b19\u0b1a\uffff\u0b1b\u0b1c\u0b1d\u0b1e !\u0b1f\u0b20\u0b21\u0b22\u0b23\u0b24)(\u0b25\u0b26,\u0b27.\u0b280123456789:; \u0b2a\u0b2b?\u0b2c\u0b2d\u0b2e\u0b2f\u0b30 \u0b32\u0b33 \u0b35\u0b36\u0b37\u0b38\u0b39\u0b3c\u0b3d\u0b3e\u0b3f\u0b40\u0b41\u0b42\u0b43\u0b44  \u0b47\u0b48  \u0b4b\u0b4c\u0b4d\u0b56abcdefghijklmnopqrstuvwxyz\u0b57\u0b60\u0b61\u0b62\u0b63", "\u0a01\u0a02\u0a03\u0a05\u0a06\u0a07\u0a08\u0a09\u0a0a \n  \r \u0a0f\u0a10  \u0a13\u0a14\u0a15\u0a16\u0a17\u0a18\u0a19\u0a1a\uffff\u0a1b\u0a1c\u0a1d\u0a1e !\u0a1f\u0a20\u0a21\u0a22\u0a23\u0a24)(\u0a25\u0a26,\u0a27.\u0a280123456789:; \u0a2a\u0a2b?\u0a2c\u0a2d\u0a2e\u0a2f\u0a30 \u0a32\u0a33 \u0a35\u0a36 \u0a38\u0a39\u0a3c \u0a3e\u0a3f\u0a40\u0a41\u0a42    \u0a47\u0a48  \u0a4b\u0a4c\u0a4d\u0a51abcdefghijklmnopqrstuvwxyz\u0a70\u0a71\u0a72\u0a73\u0a74", " \u0b82\u0b83\u0b85\u0b86\u0b87\u0b88\u0b89\u0b8a \n  \r\u0b8e\u0b8f\u0b90 \u0b92\u0b93\u0b94\u0b95   \u0b99\u0b9a\uffff \u0b9c \u0b9e !\u0b9f   \u0ba3\u0ba4)(  , .\u0ba80123456789:;\u0ba9\u0baa ?  \u0bae\u0baf\u0bb0\u0bb1\u0bb2\u0bb3\u0bb4\u0bb5\u0bb6\u0bb7\u0bb8\u0bb9  \u0bbe\u0bbf\u0bc0\u0bc1\u0bc2   \u0bc6\u0bc7\u0bc8 \u0bca\u0bcb\u0bcc\u0bcd\u0bd0abcdefghijklmnopqrstuvwxyz\u0bd7\u0bf0\u0bf1\u0bf2\u0bf9", "\u0c01\u0c02\u0c03\u0c05\u0c06\u0c07\u0c08\u0c09\u0c0a\u0c0b\n\u0c0c \r\u0c0e\u0c0f\u0c10 \u0c12\u0c13\u0c14\u0c15\u0c16\u0c17\u0c18\u0c19\u0c1a\uffff\u0c1b\u0c1c\u0c1d\u0c1e !\u0c1f\u0c20\u0c21\u0c22\u0c23\u0c24)(\u0c25\u0c26,\u0c27.\u0c280123456789:; \u0c2a\u0c2b?\u0c2c\u0c2d\u0c2e\u0c2f\u0c30\u0c31\u0c32\u0c33 \u0c35\u0c36\u0c37\u0c38\u0c39 \u0c3d\u0c3e\u0c3f\u0c40\u0c41\u0c42\u0c43\u0c44 \u0c46\u0c47\u0c48 \u0c4a\u0c4b\u0c4c\u0c4d\u0c55abcdefghijklmnopqrstuvwxyz\u0c56\u0c60\u0c61\u0c62\u0c63", "\u0627\u0622\u0628\u067b\u0680\u067e\u06a6\u062a\u06c2\u067f\n\u0679\u067d\r\u067a\u067c\u062b\u062c\u0681\u0684\u0683\u0685\u0686\u0687\u062d\u062e\u062f\uffff\u068c\u0688\u0689\u068a !\u068f\u068d\u0630\u0631\u0691\u0693)(\u0699\u0632,\u0696.\u06980123456789:;\u069a\u0633\u0634?\u0635\u0636\u0637\u0638\u0639\u0641\u0642\u06a9\u06aa\u06ab\u06af\u06b3\u06b1\u0644\u0645\u0646\u06ba\u06bb\u06bc\u0648\u06c4\u06d5\u06c1\u06be\u0621\u06cc\u06d0\u06d2\u064d\u0650\u064f\u0657\u0654abcdefghijklmnopqrstuvwxyz\u0655\u0651\u0653\u0656\u0670"};
        sLanguageShiftTables = new String[]{"          \f         ^                   {}     \\            [~] |                                    \u20ac                          ", "          \f         ^                   {}     \\            [~] |      \u011e \u0130         \u015e               \u00e7 \u20ac \u011f \u0131         \u015f            ", "         \u00e7\f         ^                   {}     \\            [~] |\u00c1       \u00cd     \u00d3     \u00da           \u00e1   \u20ac   \u00ed     \u00f3     \u00fa          ", "     \u00ea   \u00e7\f\u00d4\u00f4 \u00c1\u00e1  \u03a6\u0393^\u03a9\u03a0\u03a8\u03a3\u0398     \u00ca        {}     \\            [~] |\u00c0       \u00cd     \u00d3     \u00da     \u00c3\u00d5    \u00c2   \u20ac   \u00ed     \u00f3     \u00fa     \u00e3\u00f5  \u00e2", "@\u00a3$\u00a5\u00bf\"\u00a4%&'\f*+ -/<=>\u00a1^\u00a1_#*\u09e6\u09e7 \u09e8\u09e9\u09ea\u09eb\u09ec\u09ed\u09ee\u09ef\u09df\u09e0\u09e1\u09e2{}\u09e3\u09f2\u09f3\u09f4\u09f5\\\u09f6\u09f7\u09f8\u09f9\u09fa       [~] |ABCDEFGHIJKLMNOPQRSTUVWXYZ          \u20ac                          ", "@\u00a3$\u00a5\u00bf\"\u00a4%&'\f*+ -/<=>\u00a1^\u00a1_#*\u0964\u0965 \u0ae6\u0ae7\u0ae8\u0ae9\u0aea\u0aeb\u0aec\u0aed\u0aee\u0aef  {}     \\            [~] |ABCDEFGHIJKLMNOPQRSTUVWXYZ          \u20ac                          ", "@\u00a3$\u00a5\u00bf\"\u00a4%&'\f*+ -/<=>\u00a1^\u00a1_#*\u0964\u0965 \u0966\u0967\u0968\u0969\u096a\u096b\u096c\u096d\u096e\u096f\u0951\u0952{}\u0953\u0954\u0958\u0959\u095a\\\u095b\u095c\u095d\u095e\u095f\u0960\u0961\u0962\u0963\u0970\u0971 [~] |ABCDEFGHIJKLMNOPQRSTUVWXYZ          \u20ac                          ", "@\u00a3$\u00a5\u00bf\"\u00a4%&'\f*+ -/<=>\u00a1^\u00a1_#*\u0964\u0965 \u0ce6\u0ce7\u0ce8\u0ce9\u0cea\u0ceb\u0cec\u0ced\u0cee\u0cef\u0cde\u0cf1{}\u0cf2    \\            [~] |ABCDEFGHIJKLMNOPQRSTUVWXYZ          \u20ac                          ", "@\u00a3$\u00a5\u00bf\"\u00a4%&'\f*+ -/<=>\u00a1^\u00a1_#*\u0964\u0965 \u0d66\u0d67\u0d68\u0d69\u0d6a\u0d6b\u0d6c\u0d6d\u0d6e\u0d6f\u0d70\u0d71{}\u0d72\u0d73\u0d74\u0d75\u0d7a\\\u0d7b\u0d7c\u0d7d\u0d7e\u0d7f       [~] |ABCDEFGHIJKLMNOPQRSTUVWXYZ          \u20ac                          ", "@\u00a3$\u00a5\u00bf\"\u00a4%&'\f*+ -/<=>\u00a1^\u00a1_#*\u0964\u0965 \u0b66\u0b67\u0b68\u0b69\u0b6a\u0b6b\u0b6c\u0b6d\u0b6e\u0b6f\u0b5c\u0b5d{}\u0b5f\u0b70\u0b71  \\            [~] |ABCDEFGHIJKLMNOPQRSTUVWXYZ          \u20ac                          ", "@\u00a3$\u00a5\u00bf\"\u00a4%&'\f*+ -/<=>\u00a1^\u00a1_#*\u0964\u0965 \u0a66\u0a67\u0a68\u0a69\u0a6a\u0a6b\u0a6c\u0a6d\u0a6e\u0a6f\u0a59\u0a5a{}\u0a5b\u0a5c\u0a5e\u0a75 \\            [~] |ABCDEFGHIJKLMNOPQRSTUVWXYZ          \u20ac                          ", "@\u00a3$\u00a5\u00bf\"\u00a4%&'\f*+ -/<=>\u00a1^\u00a1_#*\u0964\u0965 \u0be6\u0be7\u0be8\u0be9\u0bea\u0beb\u0bec\u0bed\u0bee\u0bef\u0bf3\u0bf4{}\u0bf5\u0bf6\u0bf7\u0bf8\u0bfa\\            [~] |ABCDEFGHIJKLMNOPQRSTUVWXYZ          \u20ac                          ", "@\u00a3$\u00a5\u00bf\"\u00a4%&'\f*+ -/<=>\u00a1^\u00a1_#*   \u0c66\u0c67\u0c68\u0c69\u0c6a\u0c6b\u0c6c\u0c6d\u0c6e\u0c6f\u0c58\u0c59{}\u0c78\u0c79\u0c7a\u0c7b\u0c7c\\\u0c7d\u0c7e\u0c7f         [~] |ABCDEFGHIJKLMNOPQRSTUVWXYZ          \u20ac                          ", "@\u00a3$\u00a5\u00bf\"\u00a4%&'\f*+ -/<=>\u00a1^\u00a1_#*\u0600\u0601 \u06f0\u06f1\u06f2\u06f3\u06f4\u06f5\u06f6\u06f7\u06f8\u06f9\u060c\u060d{}\u060e\u060f\u0610\u0611\u0612\\\u0613\u0614\u061b\u061f\u0640\u0652\u0658\u066b\u066c\u0672\u0673\u06cd[~]\u06d4|ABCDEFGHIJKLMNOPQRSTUVWXYZ          \u20ac                          "};
        GsmAlphabet.enableCountrySpecificEncodings();
        int n = sLanguageTables.length;
        int n2 = sLanguageShiftTables.length;
        if (n != n2) {
            Rlog.e(TAG, "Error: language tables array length " + n + " != shift tables array length " + n2);
        }
        sCharsToGsmTables = new SparseIntArray[n];
        for (int i = 0; i < n; ++i) {
            SparseIntArray sparseIntArray;
            String string2 = sLanguageTables[i];
            int n3 = string2.length();
            if (n3 != 0 && n3 != 128) {
                Rlog.e(TAG, "Error: language tables index " + i + " length " + n3 + " (expected 128 or 0)");
            }
            GsmAlphabet.sCharsToGsmTables[i] = sparseIntArray = new SparseIntArray(n3);
            for (int j = 0; j < n3; ++j) {
                sparseIntArray.put(string2.charAt(j), j);
            }
        }
        sCharsToShiftTables = new SparseIntArray[n];
        for (int i = 0; i < n2; ++i) {
            SparseIntArray sparseIntArray;
            String string3 = sLanguageShiftTables[i];
            int n4 = string3.length();
            if (n4 != 0 && n4 != 128) {
                Rlog.e(TAG, "Error: language shift tables index " + i + " length " + n4 + " (expected 128 or 0)");
            }
            GsmAlphabet.sCharsToShiftTables[i] = sparseIntArray = new SparseIntArray(n4);
            for (int j = 0; j < n4; ++j) {
                char c = string3.charAt(j);
                if (c == ' ') continue;
                sparseIntArray.put(c, j);
            }
        }
    }

    private GsmAlphabet() {
    }

    public static int charToGsm(char c) {
        try {
            int n = GsmAlphabet.charToGsm(c, false);
            return n;
        }
        catch (EncodeException encodeException) {
            return sCharsToGsmTables[0].get(32, 32);
        }
    }

    public static int charToGsm(char c, boolean bl) throws EncodeException {
        int n = sCharsToGsmTables[0].get(c, -1);
        if (n == -1) {
            if (sCharsToShiftTables[0].get(c, -1) == -1) {
                if (bl) {
                    throw new EncodeException(c);
                }
                return sCharsToGsmTables[0].get(32, 32);
            }
            return 27;
        }
        return n;
    }

    public static int charToGsmExtended(char c) {
        int n = sCharsToShiftTables[0].get(c, -1);
        if (n == -1) {
            n = sCharsToGsmTables[0].get(32, 32);
        }
        return n;
    }

    public static int countGsmSeptets(char c) {
        try {
            int n = GsmAlphabet.countGsmSeptets(c, false);
            return n;
        }
        catch (EncodeException encodeException) {
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int countGsmSeptets(char c, boolean bl) throws EncodeException {
        block5: {
            block4: {
                if (sCharsToGsmTables[0].get(c, -1) != -1) break block4;
                if (sCharsToShiftTables[0].get(c, -1) != -1) {
                    return 2;
                }
                if (bl) break block5;
            }
            return 1;
        }
        throw new EncodeException(c);
    }

    /*
     * Unable to fully structure code
     */
    public static TextEncodingDetails countGsmSeptets(CharSequence var0, boolean var1_1) {
        if (!GsmAlphabet.sDisableCountryEncodingCheck) {
            GsmAlphabet.enableCountrySpecificEncodings();
        }
        if (GsmAlphabet.sEnabledSingleShiftTables.length + GsmAlphabet.sEnabledLockingShiftTables.length == 0) {
            var2_2 = new TextEncodingDetails();
            var3_3 = GsmAlphabet.countGsmSeptetsUsingTables(var0, var1_1, 0, 0);
            if (var3_3 == -1) {
                var4_4 = null;
lbl8:
                // 2 sources

                return var4_4;
            }
            var2_2.codeUnitSize = 1;
            var2_2.codeUnitCount = var3_3;
            if (var3_3 > 160) {
                var2_2.msgCount = (var3_3 + 152) / 153;
                var2_2.codeUnitsRemaining = 153 * var2_2.msgCount - var3_3;
lbl15:
                // 2 sources

                while (true) {
                    var2_2.codeUnitSize = 1;
                    return var2_2;
                }
            }
            var2_2.msgCount = 1;
            var2_2.codeUnitsRemaining = 160 - var3_3;
            ** continue;
        }
        var5_5 = GsmAlphabet.sHighestEnabledSingleShiftCode;
        var6_6 = new ArrayList<LanguagePairCount>(1 + GsmAlphabet.sEnabledLockingShiftTables.length);
        var6_6.add(new LanguagePairCount(0));
        for (int var37_10 : GsmAlphabet.sEnabledLockingShiftTables) {
            if (var37_10 == 0 || GsmAlphabet.sLanguageTables[var37_10].isEmpty()) continue;
            var38_11 = new LanguagePairCount(var37_10);
            var6_6.add(var38_11);
        }
        var11_12 = var0.length();
        block3: for (var12_13 = 0; var12_13 < var11_12 && !var6_6.isEmpty(); ++var12_13) {
            var27_18 = var0.charAt(var12_13);
            if (var27_18 == '\u001b') {
                Rlog.w("GSM", "countGsmSeptets() string contains Escape character, ignoring!");
                continue block3;
            }
            var28_19 = var6_6.iterator();
            while (true) lbl-1000:
            // 3 sources

            {
                block24: {
                    block23: {
                        if (!var28_19.hasNext()) ** continue;
                        var29_20 = (LanguagePairCount)var28_19.next();
                        if (GsmAlphabet.sCharsToGsmTables[var29_20.languageCode].get(var27_18, -1) != -1) break block24;
                        var32_14 = 0;
                        block6: while (true) {
                            if (var32_14 > var5_5) ** continue;
                            if (var29_20.septetCounts[var32_14] != -1) {
                                if (GsmAlphabet.sCharsToShiftTables[var32_14].get(var27_18, -1) != -1) break block23;
                                if (!var1_1) break;
                                var34_16 = var29_20.septetCounts;
                                var34_16[var32_14] = 1 + var34_16[var32_14];
                                var35_17 = var29_20.unencodableCounts;
                                var35_17[var32_14] = 1 + var35_17[var32_14];
                            }
lbl54:
                            // 5 sources

                            while (true) {
                                ++var32_14;
                                continue block6;
                                break;
                            }
                            break;
                        }
                        var29_20.septetCounts[var32_14] = -1;
                        ** GOTO lbl54
                    }
                    var33_15 = var29_20.septetCounts;
                    var33_15[var32_14] = 2 + var33_15[var32_14];
                    ** continue;
                }
                var30_21 = 0;
                while (true) {
                    if (var30_21 <= var5_5) ** break;
                    ** continue;
                    if (var29_20.septetCounts[var30_21] != -1) {
                        var31_22 = var29_20.septetCounts;
                        var31_22[var30_21] = 1 + var31_22[var30_21];
                    }
                    ++var30_21;
                }
                break;
            }
        }
        var4_4 = new TextEncodingDetails();
        var4_4.msgCount = 0x7FFFFFFF;
        var4_4.codeUnitSize = 1;
        var13_23 = 0x7FFFFFFF;
        for (LanguagePairCount var15_25 : var6_6) {
            block10: for (var16_26 = 0; var16_26 <= var5_5; ++var16_26) {
                block26: {
                    block27: {
                        block25: {
                            var17_27 = var15_25.septetCounts[var16_26];
                            if (var17_27 == -1) lbl-1000:
                            // 3 sources

                            {
                                continue block10;
                            }
                            if (var15_25.languageCode == 0 || var16_26 == 0) break block25;
                            var18_28 = 8;
lbl85:
                            // 3 sources

                            while (var17_27 + var18_28 > 160) {
                                if (var18_28 == 0) {
                                    var18_28 = 1;
                                }
                                var26_36 = 160 - (var18_28 + 6);
                                var19_29 = (-1 + (var17_27 + var26_36)) / var26_36;
                                var20_30 = var19_29 * var26_36 - var17_27;
lbl91:
                                // 2 sources

                                while (true) {
                                    var21_31 = var15_25.unencodableCounts[var16_26];
                                    if (var1_1 && var21_31 > var13_23 || (!var1_1 || var21_31 >= var13_23) && var19_29 >= var4_4.msgCount && (var19_29 != var4_4.msgCount || var20_30 <= (var25_35 = var4_4.codeUnitsRemaining))) ** GOTO lbl-1000
                                    var13_23 = var21_31;
                                    var4_4.msgCount = var19_29;
                                    var4_4.codeUnitCount = var17_27;
                                    var4_4.codeUnitsRemaining = var22_32 = var20_30;
                                    var4_4.languageTable = var23_33 = var15_25.languageCode;
                                    var4_4.languageShiftTable = var24_34 = var16_26;
                                    ** continue;
                                    break;
                                }
lbl101:
                                // 1 sources

                                ** GOTO lbl-1000
                            }
                            break block26;
                        }
                        if (var15_25.languageCode == 0 && var16_26 == 0) break block27;
                        var18_28 = 5;
                        ** GOTO lbl85
                    }
                    var18_28 = 0;
                    ** GOTO lbl85
                }
                var19_29 = 1;
                var20_30 = 160 - var18_28 - var17_27;
                ** continue;
            }
        }
        ** while (var4_4.msgCount != 0x7FFFFFFF)
lbl116:
        // 1 sources

        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int countGsmSeptetsUsingTables(CharSequence charSequence, boolean bl, int n, int n2) {
        int n3 = 0;
        int n4 = charSequence.length();
        SparseIntArray sparseIntArray = sCharsToGsmTables[n];
        SparseIntArray sparseIntArray2 = sCharsToShiftTables[n2];
        int n5 = 0;
        while (n5 < n4) {
            char c = charSequence.charAt(n5);
            if (c == '\u001b') {
                Rlog.w(TAG, "countGsmSeptets() string contains Escape character, skipping.");
            } else if (sparseIntArray.get(c, -1) != -1) {
                ++n3;
            } else if (sparseIntArray2.get(c, -1) != -1) {
                n3 += 2;
            } else {
                if (!bl) return -1;
                ++n3;
            }
            ++n5;
        }
        return n3;
    }

    private static void enableCountrySpecificEncodings() {
        Resources resources = Resources.getSystem();
        sEnabledSingleShiftTables = resources.getIntArray(17236009);
        sEnabledLockingShiftTables = resources.getIntArray(17236010);
        if (sEnabledSingleShiftTables.length > 0) {
            sHighestEnabledSingleShiftCode = sEnabledSingleShiftTables[-1 + sEnabledSingleShiftTables.length];
            return;
        }
        sHighestEnabledSingleShiftCode = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int findGsmSeptetLimitIndex(String string2, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = string2.length();
        SparseIntArray sparseIntArray = sCharsToGsmTables[n3];
        SparseIntArray sparseIntArray2 = sCharsToShiftTables[n4];
        int n7 = n;
        while (n7 < n6) {
            n5 = sparseIntArray.get(string2.charAt(n7), -1) == -1 ? (sparseIntArray2.get(string2.charAt(n7), -1) == -1 ? ++n5 : (n5 += 2)) : ++n5;
            if (n5 > n2) {
                return n7;
            }
            ++n7;
        }
        return n6;
    }

    static int[] getEnabledLockingShiftTables() {
        synchronized (GsmAlphabet.class) {
            int[] nArray = sEnabledLockingShiftTables;
            return nArray;
        }
    }

    static int[] getEnabledSingleShiftTables() {
        synchronized (GsmAlphabet.class) {
            int[] nArray = sEnabledSingleShiftTables;
            return nArray;
        }
    }

    public static String gsm7BitPackedToString(byte[] byArray, int n, int n2) {
        return GsmAlphabet.gsm7BitPackedToString(byArray, n, n2, 0, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String gsm7BitPackedToString(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        StringBuilder stringBuilder = new StringBuilder(n2);
        if (n4 < 0 || n4 > (n7 = sLanguageTables.length)) {
            Rlog.w(TAG, "unknown language table " + n4 + ", using default");
            n4 = 0;
        }
        if (n5 < 0 || n5 > (n6 = sLanguageShiftTables.length)) {
            Rlog.w(TAG, "unknown single shift table " + n5 + ", using default");
            n5 = 0;
        }
        String string2 = sLanguageTables[n4];
        String string3 = sLanguageShiftTables[n5];
        if (string2.isEmpty()) {
            Rlog.w(TAG, "no language table for code " + n4 + ", using default");
            string2 = sLanguageTables[0];
        }
        if (string3.isEmpty()) {
            Rlog.w(TAG, "no single shift table for code " + n5 + ", using default");
            string3 = sLanguageShiftTables[0];
        }
        int n8 = 0;
        boolean bl = false;
        while (true) {
            block18: {
                int n9;
                block15: {
                    block16: {
                        char c;
                        block17: {
                            int n10;
                            int n11;
                            if (n8 >= n2) {
                                return stringBuilder.toString();
                            }
                            int n12 = n3 + n8 * 7;
                            try {
                                n11 = n12 / 8;
                                n10 = n12 % 8;
                            }
                            catch (RuntimeException runtimeException) {
                                Rlog.e(TAG, "Error GSM 7 bit packed: ", runtimeException);
                                return null;
                            }
                            n9 = 0x7F & byArray[n + n11] >> n10;
                            if (n10 > 1) {
                                n9 = n9 & 127 >> n10 - 1 | 0x7F & byArray[1 + (n + n11)] << 8 - n10;
                            }
                            if (!bl) break block15;
                            if (n9 == 27) {
                                stringBuilder.append(' ');
                                break block16;
                            }
                            c = string3.charAt(n9);
                            if (c != ' ') break block17;
                            stringBuilder.append(string2.charAt(n9));
                        }
                        stringBuilder.append(c);
                    }
                    bl = false;
                    break block18;
                }
                if (n9 == 27) {
                    bl = true;
                } else {
                    stringBuilder.append(string2.charAt(n9));
                }
            }
            ++n8;
        }
    }

    public static String gsm8BitUnpackedToString(byte[] byArray, int n, int n2) {
        return GsmAlphabet.gsm8BitUnpackedToString(byArray, n, n2, "");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String gsm8BitUnpackedToString(byte[] byArray, int n, int n2, String string2) {
        boolean bl = TextUtils.isEmpty(string2);
        Charset charset = null;
        boolean bl2 = false;
        ByteBuffer byteBuffer = null;
        if (!bl) {
            boolean bl3 = string2.equalsIgnoreCase("us-ascii");
            charset = null;
            bl2 = false;
            byteBuffer = null;
            if (!bl3) {
                boolean bl4 = Charset.isSupported(string2);
                charset = null;
                bl2 = false;
                byteBuffer = null;
                if (bl4) {
                    bl2 = true;
                    charset = Charset.forName(string2);
                    byteBuffer = ByteBuffer.allocate(2);
                }
            }
        }
        String string3 = sLanguageTables[0];
        String string4 = sLanguageShiftTables[0];
        StringBuilder stringBuilder = new StringBuilder(n2);
        boolean bl5 = false;
        int n3 = n;
        int n4;
        while (n3 < n + n2 && (n4 = 0xFF & byArray[n3]) != 255) {
            int n5;
            if (n4 == 27) {
                if (bl5) {
                    stringBuilder.append(' ');
                    bl5 = false;
                    n5 = n3;
                } else {
                    bl5 = true;
                    n5 = n3;
                }
            } else {
                if (bl5) {
                    char c = n4 < string4.length() ? (char)string4.charAt(n4) : (char)' ';
                    if (c == ' ') {
                        if (n4 < string3.length()) {
                            stringBuilder.append(string3.charAt(n4));
                        } else {
                            stringBuilder.append(' ');
                        }
                    } else {
                        stringBuilder.append(c);
                    }
                    n5 = n3;
                } else if (!bl2 || n4 < 128 || n3 + 1 >= n + n2) {
                    if (n4 < string3.length()) {
                        stringBuilder.append(string3.charAt(n4));
                        n5 = n3;
                    } else {
                        stringBuilder.append(' ');
                        n5 = n3;
                    }
                } else {
                    byteBuffer.clear();
                    n5 = n3 + 1;
                    byteBuffer.put(byArray, n3, 2);
                    byteBuffer.flip();
                    stringBuilder.append(charset.decode(byteBuffer).toString());
                }
                bl5 = false;
            }
            n3 = n5 + 1;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static char gsmExtendedToChar(int n) {
        if (n == 27) {
            return ' ';
        }
        if (n < 0) return ' ';
        if (n >= 128) return ' ';
        char c = sLanguageShiftTables[0].charAt(n);
        if (c != 32) return c;
        return sLanguageTables[0].charAt(n);
    }

    public static char gsmToChar(int n) {
        if (n >= 0 && n < 128) {
            return sLanguageTables[0].charAt(n);
        }
        return ' ';
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isGsmSeptets(char c) {
        return sCharsToGsmTables[0].get(c, -1) != -1 || sCharsToShiftTables[0].get(c, -1) != -1;
    }

    private static void packSmsChar(byte[] byArray, int n, int n2) {
        int n3 = n / 8;
        int n4 = n % 8;
        int n5 = n3 + 1;
        byArray[n5] = (byte)(byArray[n5] | n2 << n4);
        if (n4 > 1) {
            byArray[n5 + 1] = (byte)(n2 >> 8 - n4);
        }
    }

    static void setEnabledLockingShiftTables(int[] nArray) {
        synchronized (GsmAlphabet.class) {
            sEnabledLockingShiftTables = nArray;
            sDisableCountryEncodingCheck = true;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void setEnabledSingleShiftTables(int[] nArray) {
        synchronized (GsmAlphabet.class) {
            sEnabledSingleShiftTables = nArray;
            sDisableCountryEncodingCheck = true;
            if (nArray.length > 0) {
                sHighestEnabledSingleShiftCode = nArray[-1 + nArray.length];
                return;
            }
            sHighestEnabledSingleShiftCode = 0;
            return;
        }
    }

    public static byte[] stringToGsm7BitPacked(String string2) throws EncodeException {
        return GsmAlphabet.stringToGsm7BitPacked(string2, 0, true, 0, 0);
    }

    public static byte[] stringToGsm7BitPacked(String string2, int n, int n2) throws EncodeException {
        return GsmAlphabet.stringToGsm7BitPacked(string2, 0, true, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] stringToGsm7BitPacked(String string2, int n, boolean bl, int n2, int n3) throws EncodeException {
        int n4 = string2.length();
        boolean bl2 = !bl;
        int n5 = GsmAlphabet.countGsmSeptetsUsingTables(string2, bl2, n2, n3);
        if (n5 == -1) {
            throw new EncodeException("countGsmSeptetsUsingTables(): unencodable char");
        }
        int n6 = n5 + n;
        if (n6 > 255) {
            throw new EncodeException("Payload cannot exceed 255 septets");
        }
        byte[] byArray = new byte[1 + (7 + n6 * 7) / 8];
        SparseIntArray sparseIntArray = sCharsToGsmTables[n2];
        SparseIntArray sparseIntArray2 = sCharsToShiftTables[n3];
        int n7 = 0;
        int n8 = n * 7;
        for (int i = n; n7 < n4 && i < n6; ++i, ++n7, n8 += 7) {
            char c = string2.charAt(n7);
            int n9 = sparseIntArray.get(c, -1);
            if (n9 == -1) {
                n9 = sparseIntArray2.get(c, -1);
                if (n9 == -1) {
                    if (bl) {
                        throw new EncodeException("stringToGsm7BitPacked(): unencodable char");
                    }
                    n9 = sparseIntArray.get(32, 32);
                } else {
                    GsmAlphabet.packSmsChar(byArray, n8, 27);
                    n8 += 7;
                    ++i;
                }
            }
            GsmAlphabet.packSmsChar(byArray, n8, n9);
        }
        byArray[0] = (byte)n6;
        return byArray;
    }

    public static byte[] stringToGsm7BitPackedWithHeader(String string2, byte[] byArray) throws EncodeException {
        return GsmAlphabet.stringToGsm7BitPackedWithHeader(string2, byArray, 0, 0);
    }

    public static byte[] stringToGsm7BitPackedWithHeader(String string2, byte[] byArray, int n, int n2) throws EncodeException {
        if (byArray == null || byArray.length == 0) {
            return GsmAlphabet.stringToGsm7BitPacked(string2, n, n2);
        }
        byte[] byArray2 = GsmAlphabet.stringToGsm7BitPacked(string2, (6 + 8 * (1 + byArray.length)) / 7, true, n, n2);
        byArray2[1] = (byte)byArray.length;
        System.arraycopy((byte[])byArray, (int)0, (byte[])byArray2, (int)2, (int)byArray.length);
        return byArray2;
    }

    public static byte[] stringToGsm8BitPacked(String string2) {
        byte[] byArray = new byte[GsmAlphabet.countGsmSeptetsUsingTables(string2, true, 0, 0)];
        GsmAlphabet.stringToGsm8BitUnpackedField(string2, byArray, 0, byArray.length);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void stringToGsm8BitUnpackedField(String string2, byte[] byArray, int n, int n2) {
        SparseIntArray sparseIntArray = sCharsToGsmTables[0];
        SparseIntArray sparseIntArray2 = sCharsToShiftTables[0];
        int n3 = string2.length();
        int n4 = n;
        for (int i = 0; i < n3 && n4 - n < n2; ++i) {
            int n5;
            char c = string2.charAt(i);
            int n6 = sparseIntArray.get(c, -1);
            if (n6 == -1) {
                n6 = sparseIntArray2.get(c, -1);
                if (n6 == -1) {
                    n6 = sparseIntArray.get(32, 32);
                    n5 = n4;
                } else {
                    if (n4 + 1 - n >= n2) break;
                    n5 = n4 + 1;
                    byArray[n4] = 27;
                }
            } else {
                n5 = n4;
            }
            n4 = n5 + 1;
            byArray[n5] = (byte)n6;
        }
        while (n4 - n < n2) {
            int n7 = n4 + 1;
            byArray[n4] = -1;
            n4 = n7;
        }
        return;
    }

    private static class LanguagePairCount {
        final int languageCode;
        final int[] septetCounts;
        final int[] unencodableCounts;

        /*
         * Enabled aggressive block sorting
         */
        LanguagePairCount(int n) {
            this.languageCode = n;
            int n2 = sHighestEnabledSingleShiftCode;
            this.septetCounts = new int[n2 + 1];
            this.unencodableCounts = new int[n2 + 1];
            int n3 = 0;
            for (int i = 1; i <= n2; ++i) {
                if (sEnabledSingleShiftTables[n3] == i) {
                    ++n3;
                    continue;
                }
                this.septetCounts[i] = -1;
            }
            if (n == 1 && n2 >= 1) {
                this.septetCounts[1] = -1;
                return;
            } else {
                if (n != 3 || n2 < 2) return;
                this.septetCounts[2] = -1;
                return;
            }
        }
    }

    public static class TextEncodingDetails {
        public int codeUnitCount;
        public int codeUnitSize;
        public int codeUnitsRemaining;
        public int languageShiftTable;
        public int languageTable;
        public int msgCount;

        public String toString() {
            return "TextEncodingDetails { msgCount=" + this.msgCount + ", codeUnitCount=" + this.codeUnitCount + ", codeUnitsRemaining=" + this.codeUnitsRemaining + ", codeUnitSize=" + this.codeUnitSize + ", languageTable=" + this.languageTable + ", languageShiftTable=" + this.languageShiftTable + " }";
        }
    }
}

