/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.util.IState;
import com.android.internal.util.State;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class StateMachine {
    public static final boolean HANDLED = true;
    public static final boolean NOT_HANDLED = false;
    private static final int SM_INIT_CMD = -2;
    private static final int SM_QUIT_CMD = -1;
    private String mName;
    private SmHandler mSmHandler;
    private HandlerThread mSmThread;

    protected StateMachine(String string2) {
        this.mSmThread = new HandlerThread(string2);
        this.mSmThread.start();
        this.initStateMachine(string2, this.mSmThread.getLooper());
    }

    protected StateMachine(String string2, Handler handler) {
        this.initStateMachine(string2, handler.getLooper());
    }

    protected StateMachine(String string2, Looper looper) {
        this.initStateMachine(string2, looper);
    }

    static /* synthetic */ HandlerThread access$402(StateMachine stateMachine, HandlerThread handlerThread) {
        stateMachine.mSmThread = handlerThread;
        return handlerThread;
    }

    static /* synthetic */ SmHandler access$502(StateMachine stateMachine, SmHandler smHandler) {
        stateMachine.mSmHandler = smHandler;
        return smHandler;
    }

    private void initStateMachine(String string2, Looper looper) {
        this.mName = string2;
        this.mSmHandler = new SmHandler(looper, this);
    }

    protected void addLogRec(String string2) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.mLogRecords.add(this, smHandler.getCurrentMessage(), string2, smHandler.getCurrentState(), ((SmHandler)smHandler).mStateStack[((SmHandler)smHandler).mStateStackTopIndex].state, smHandler.mDestState);
    }

    protected final void addState(State state) {
        this.mSmHandler.addState(state, null);
    }

    protected final void addState(State state, State state2) {
        this.mSmHandler.addState(state, state2);
    }

    public final Collection<LogRec> copyLogRecs() {
        Vector<LogRec> vector = new Vector<LogRec>();
        SmHandler smHandler = this.mSmHandler;
        if (smHandler != null) {
            Iterator iterator = smHandler.mLogRecords.mLogRecVector.iterator();
            while (iterator.hasNext()) {
                vector.add((LogRec)iterator.next());
            }
        }
        return vector;
    }

    protected final void deferMessage(Message message) {
        this.mSmHandler.deferMessage(message);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.println(this.getName() + ":");
        printWriter.println(" total records=" + this.getLogRecCount());
        for (int i = 0; i < this.getLogRecSize(); ++i) {
            Object[] objectArray = new Object[]{i, this.getLogRec(i).toString()};
            printWriter.printf(" rec[%d]: %s\n", objectArray);
            printWriter.flush();
        }
        printWriter.println("curState=" + this.getCurrentState().getName());
    }

    protected final Message getCurrentMessage() {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return null;
        }
        return smHandler.getCurrentMessage();
    }

    protected final IState getCurrentState() {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return null;
        }
        return smHandler.getCurrentState();
    }

    public final Handler getHandler() {
        return this.mSmHandler;
    }

    public final LogRec getLogRec(int n) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return null;
        }
        return smHandler.mLogRecords.get(n);
    }

    public final int getLogRecCount() {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return 0;
        }
        return smHandler.mLogRecords.count();
    }

    public final int getLogRecSize() {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return 0;
        }
        return smHandler.mLogRecords.size();
    }

    protected String getLogRecString(Message message) {
        return "";
    }

    public final String getName() {
        return this.mName;
    }

    protected String getWhatToString(int n) {
        return null;
    }

    protected void haltedProcessMessage(Message message) {
    }

    public boolean isDbg() {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return false;
        }
        return smHandler.isDbg();
    }

    protected final boolean isQuit(Message message) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return message.what == -1;
        }
        return smHandler.isQuit(message);
    }

    protected void log(String string2) {
        Log.d(this.mName, string2);
    }

    protected void logAndAddLogRec(String string2) {
        this.addLogRec(string2);
        this.log(string2);
    }

    protected void logd(String string2) {
        Log.d(this.mName, string2);
    }

    protected void loge(String string2) {
        Log.e(this.mName, string2);
    }

    protected void loge(String string2, Throwable throwable) {
        Log.e(this.mName, string2, throwable);
    }

    protected void logi(String string2) {
        Log.i(this.mName, string2);
    }

    protected void logv(String string2) {
        Log.v(this.mName, string2);
    }

    protected void logw(String string2) {
        Log.w(this.mName, string2);
    }

    public final Message obtainMessage() {
        return Message.obtain(this.mSmHandler);
    }

    public final Message obtainMessage(int n) {
        return Message.obtain((Handler)this.mSmHandler, n);
    }

    public final Message obtainMessage(int n, int n2) {
        return Message.obtain(this.mSmHandler, n, n2, 0);
    }

    public final Message obtainMessage(int n, int n2, int n3) {
        return Message.obtain(this.mSmHandler, n, n2, n3);
    }

    public final Message obtainMessage(int n, int n2, int n3, Object object) {
        return Message.obtain(this.mSmHandler, n, n2, n3, object);
    }

    public final Message obtainMessage(int n, Object object) {
        return Message.obtain(this.mSmHandler, n, object);
    }

    protected void onHalting() {
    }

    protected void onQuitting() {
    }

    protected final void quit() {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.quit();
    }

    protected final void quitNow() {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.quitNow();
    }

    protected boolean recordLogRec(Message message) {
        return true;
    }

    protected final void removeMessages(int n) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.removeMessages(n);
    }

    public final void sendMessage(int n) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessage(this.obtainMessage(n));
    }

    public final void sendMessage(int n, int n2) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessage(this.obtainMessage(n, n2));
    }

    public final void sendMessage(int n, int n2, int n3) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessage(this.obtainMessage(n, n2, n3));
    }

    public final void sendMessage(int n, int n2, int n3, Object object) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessage(this.obtainMessage(n, n2, n3, object));
    }

    public final void sendMessage(int n, Object object) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessage(this.obtainMessage(n, object));
    }

    public final void sendMessage(Message message) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessage(message);
    }

    protected final void sendMessageAtFrontOfQueue(int n) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessageAtFrontOfQueue(this.obtainMessage(n));
    }

    protected final void sendMessageAtFrontOfQueue(int n, int n2) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessageAtFrontOfQueue(this.obtainMessage(n, n2));
    }

    protected final void sendMessageAtFrontOfQueue(int n, int n2, int n3) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessageAtFrontOfQueue(this.obtainMessage(n, n2, n3));
    }

    protected final void sendMessageAtFrontOfQueue(int n, int n2, int n3, Object object) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessageAtFrontOfQueue(this.obtainMessage(n, n2, n3, object));
    }

    protected final void sendMessageAtFrontOfQueue(int n, Object object) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessageAtFrontOfQueue(this.obtainMessage(n, object));
    }

    protected final void sendMessageAtFrontOfQueue(Message message) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessageAtFrontOfQueue(message);
    }

    public final void sendMessageDelayed(int n, int n2, int n3, long l) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessageDelayed(this.obtainMessage(n, n2, n3), l);
    }

    public final void sendMessageDelayed(int n, int n2, int n3, Object object, long l) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessageDelayed(this.obtainMessage(n, n2, n3, object), l);
    }

    public final void sendMessageDelayed(int n, int n2, long l) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessageDelayed(this.obtainMessage(n, n2), l);
    }

    public final void sendMessageDelayed(int n, long l) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessageDelayed(this.obtainMessage(n), l);
    }

    public final void sendMessageDelayed(int n, Object object, long l) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessageDelayed(this.obtainMessage(n, object), l);
    }

    public final void sendMessageDelayed(Message message, long l) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.sendMessageDelayed(message, l);
    }

    public void setDbg(boolean bl) {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.setDbg(bl);
    }

    protected final void setInitialState(State state) {
        this.mSmHandler.setInitialState(state);
    }

    public final void setLogOnlyTransitions(boolean bl) {
        this.mSmHandler.mLogRecords.setLogOnlyTransitions(bl);
    }

    public final void setLogRecSize(int n) {
        this.mSmHandler.mLogRecords.setSize(n);
    }

    public void start() {
        SmHandler smHandler = this.mSmHandler;
        if (smHandler == null) {
            return;
        }
        smHandler.completeConstruction();
    }

    protected final void transitionTo(IState iState) {
        this.mSmHandler.transitionTo(iState);
    }

    protected final void transitionToHaltingState() {
        this.mSmHandler.transitionTo(this.mSmHandler.mHaltingState);
    }

    protected void unhandledMessage(Message message) {
        if (this.mSmHandler.mDbg) {
            this.loge(" - unhandledMessage: msg.what=" + message.what);
        }
    }

    public static class LogRec {
        private IState mDstState;
        private String mInfo;
        private IState mOrgState;
        private StateMachine mSm;
        private IState mState;
        private long mTime;
        private int mWhat;

        LogRec(StateMachine stateMachine, Message message, String string2, IState iState, IState iState2, IState iState3) {
            this.update(stateMachine, message, string2, iState, iState2, iState3);
        }

        public IState getDestState() {
            return this.mDstState;
        }

        public String getInfo() {
            return this.mInfo;
        }

        public IState getOriginalState() {
            return this.mOrgState;
        }

        public IState getState() {
            return this.mState;
        }

        public long getTime() {
            return this.mTime;
        }

        public long getWhat() {
            return this.mWhat;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("time=");
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(this.mTime);
            stringBuilder.append(String.format("%tm-%td %tH:%tM:%tS.%tL", calendar, calendar, calendar, calendar, calendar, calendar));
            stringBuilder.append(" processed=");
            String string2 = this.mState == null ? "<null>" : this.mState.getName();
            stringBuilder.append(string2);
            stringBuilder.append(" org=");
            String string3 = this.mOrgState == null ? "<null>" : this.mOrgState.getName();
            stringBuilder.append(string3);
            stringBuilder.append(" dest=");
            String string4 = this.mDstState == null ? "<null>" : this.mDstState.getName();
            stringBuilder.append(string4);
            stringBuilder.append(" what=");
            String string5 = this.mSm != null ? this.mSm.getWhatToString(this.mWhat) : "";
            if (TextUtils.isEmpty(string5)) {
                stringBuilder.append(this.mWhat);
                stringBuilder.append("(0x");
                stringBuilder.append(Integer.toHexString(this.mWhat));
                stringBuilder.append(")");
            } else {
                stringBuilder.append(string5);
            }
            if (!TextUtils.isEmpty(this.mInfo)) {
                stringBuilder.append(" ");
                stringBuilder.append(this.mInfo);
            }
            return stringBuilder.toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        public void update(StateMachine stateMachine, Message message, String string2, IState iState, IState iState2, IState iState3) {
            this.mSm = stateMachine;
            this.mTime = System.currentTimeMillis();
            int n = message != null ? message.what : 0;
            this.mWhat = n;
            this.mInfo = string2;
            this.mState = iState;
            this.mOrgState = iState2;
            this.mDstState = iState3;
        }
    }

    private static class LogRecords {
        private static final int DEFAULT_SIZE = 20;
        private int mCount = 0;
        private boolean mLogOnlyTransitions = false;
        private Vector<LogRec> mLogRecVector = new Vector();
        private int mMaxSize = 20;
        private int mOldestIndex = 0;

        private LogRecords() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void add(StateMachine stateMachine, Message message, String string2, IState iState, IState iState2, IState iState3) {
            synchronized (this) {
                this.mCount = 1 + this.mCount;
                if (this.mLogRecVector.size() < this.mMaxSize) {
                    this.mLogRecVector.add(new LogRec(stateMachine, message, string2, iState, iState2, iState3));
                } else {
                    LogRec logRec = this.mLogRecVector.get(this.mOldestIndex);
                    this.mOldestIndex = 1 + this.mOldestIndex;
                    if (this.mOldestIndex >= this.mMaxSize) {
                        this.mOldestIndex = 0;
                    }
                    logRec.update(stateMachine, message, string2, iState, iState2, iState3);
                }
                return;
            }
        }

        void cleanup() {
            synchronized (this) {
                this.mLogRecVector.clear();
                return;
            }
        }

        int count() {
            synchronized (this) {
                int n = this.mCount;
                return n;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        LogRec get(int n) {
            synchronized (this) {
                int n2;
                block7: {
                    int n3;
                    n2 = n + this.mOldestIndex;
                    if (n2 >= this.mMaxSize) {
                        n2 -= this.mMaxSize;
                    }
                    if (n2 < (n3 = this.size())) break block7;
                    return null;
                }
                LogRec logRec = this.mLogRecVector.get(n2);
                return logRec;
            }
        }

        boolean logOnlyTransitions() {
            synchronized (this) {
                boolean bl = this.mLogOnlyTransitions;
                return bl;
            }
        }

        void setLogOnlyTransitions(boolean bl) {
            synchronized (this) {
                this.mLogOnlyTransitions = bl;
                return;
            }
        }

        void setSize(int n) {
            synchronized (this) {
                this.mMaxSize = n;
                this.mCount = 0;
                this.mLogRecVector.clear();
                return;
            }
        }

        int size() {
            synchronized (this) {
                int n = this.mLogRecVector.size();
                return n;
            }
        }
    }

    private static class SmHandler
    extends Handler {
        private static final Object mSmHandlerObj = new Object();
        private boolean mDbg = false;
        private ArrayList<Message> mDeferredMessages;
        private State mDestState;
        private HaltingState mHaltingState;
        private boolean mHasQuit = false;
        private State mInitialState;
        private boolean mIsConstructionCompleted;
        private LogRecords mLogRecords = new LogRecords();
        private Message mMsg;
        private QuittingState mQuittingState;
        private StateMachine mSm;
        private HashMap<State, StateInfo> mStateInfo;
        private StateInfo[] mStateStack;
        private int mStateStackTopIndex = -1;
        private StateInfo[] mTempStateStack;
        private int mTempStateStackCount;

        private SmHandler(Looper looper, StateMachine stateMachine) {
            super(looper);
            this.mHaltingState = new HaltingState();
            this.mQuittingState = new QuittingState();
            this.mStateInfo = new HashMap();
            this.mDeferredMessages = new ArrayList();
            this.mSm = stateMachine;
            this.addState(this.mHaltingState, null);
            this.addState(this.mQuittingState, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final StateInfo addState(State state, State state2) {
            StateInfo stateInfo;
            if (this.mDbg) {
                StateMachine stateMachine = this.mSm;
                StringBuilder stringBuilder = new StringBuilder().append("addStateInternal: E state=").append(state.getName()).append(",parent=");
                String string2 = state2 == null ? "" : state2.getName();
                stateMachine.log(stringBuilder.append(string2).toString());
            }
            StateInfo stateInfo2 = null;
            if (state2 != null && (stateInfo2 = this.mStateInfo.get(state2)) == null) {
                stateInfo2 = this.addState(state2, null);
            }
            if ((stateInfo = this.mStateInfo.get(state)) == null) {
                stateInfo = new StateInfo();
                this.mStateInfo.put(state, stateInfo);
            }
            if (stateInfo.parentStateInfo != null && stateInfo.parentStateInfo != stateInfo2) {
                throw new RuntimeException("state already added");
            }
            stateInfo.state = state;
            stateInfo.parentStateInfo = stateInfo2;
            stateInfo.active = false;
            if (this.mDbg) {
                this.mSm.log("addStateInternal: X stateInfo: " + stateInfo);
            }
            return stateInfo;
        }

        private final void cleanupAfterQuitting() {
            if (this.mSm.mSmThread != null) {
                this.getLooper().quit();
                StateMachine.access$402(this.mSm, null);
            }
            StateMachine.access$502(this.mSm, null);
            this.mSm = null;
            this.mMsg = null;
            this.mLogRecords.cleanup();
            this.mStateStack = null;
            this.mTempStateStack = null;
            this.mStateInfo.clear();
            this.mInitialState = null;
            this.mDestState = null;
            this.mDeferredMessages.clear();
            this.mHasQuit = true;
        }

        private final void completeConstruction() {
            if (this.mDbg) {
                this.mSm.log("completeConstruction: E");
            }
            int n = 0;
            for (StateInfo stateInfo : this.mStateInfo.values()) {
                int n2 = 0;
                StateInfo stateInfo2 = stateInfo;
                while (stateInfo2 != null) {
                    stateInfo2 = stateInfo2.parentStateInfo;
                    ++n2;
                }
                if (n >= n2) continue;
                n = n2;
            }
            if (this.mDbg) {
                this.mSm.log("completeConstruction: maxDepth=" + n);
            }
            this.mStateStack = new StateInfo[n];
            this.mTempStateStack = new StateInfo[n];
            this.setupInitialStateStack();
            this.sendMessageAtFrontOfQueue(this.obtainMessage(-2, mSmHandlerObj));
            if (this.mDbg) {
                this.mSm.log("completeConstruction: X");
            }
        }

        private final void deferMessage(Message message) {
            if (this.mDbg) {
                this.mSm.log("deferMessage: msg=" + message.what);
            }
            Message message2 = this.obtainMessage();
            message2.copyFrom(message);
            this.mDeferredMessages.add(message2);
        }

        private final Message getCurrentMessage() {
            return this.mMsg;
        }

        private final IState getCurrentState() {
            return this.mStateStack[this.mStateStackTopIndex].state;
        }

        private final void invokeEnterMethods(int n) {
            for (int i = n; i <= this.mStateStackTopIndex; ++i) {
                if (this.mDbg) {
                    this.mSm.log("invokeEnterMethods: " + this.mStateStack[i].state.getName());
                }
                this.mStateStack[i].state.enter();
                this.mStateStack[i].active = true;
            }
        }

        private final void invokeExitMethods(StateInfo stateInfo) {
            while (this.mStateStackTopIndex >= 0 && this.mStateStack[this.mStateStackTopIndex] != stateInfo) {
                State state = this.mStateStack[this.mStateStackTopIndex].state;
                if (this.mDbg) {
                    this.mSm.log("invokeExitMethods: " + state.getName());
                }
                state.exit();
                this.mStateStack[this.mStateStackTopIndex].active = false;
                this.mStateStackTopIndex = -1 + this.mStateStackTopIndex;
            }
        }

        private final boolean isDbg() {
            return this.mDbg;
        }

        private final boolean isQuit(Message message) {
            return message.what == -1 && message.obj == mSmHandlerObj;
        }

        private final void moveDeferredMessageAtFrontOfQueue() {
            for (int i = -1 + this.mDeferredMessages.size(); i >= 0; --i) {
                Message message = this.mDeferredMessages.get(i);
                if (this.mDbg) {
                    this.mSm.log("moveDeferredMessageAtFrontOfQueue; what=" + message.what);
                }
                this.sendMessageAtFrontOfQueue(message);
            }
            this.mDeferredMessages.clear();
        }

        private final int moveTempStateStackToStateStack() {
            int n = 1 + this.mStateStackTopIndex;
            int n2 = n;
            for (int i = -1 + this.mTempStateStackCount; i >= 0; --i) {
                if (this.mDbg) {
                    this.mSm.log("moveTempStackToStateStack: i=" + i + ",j=" + n2);
                }
                this.mStateStack[n2] = this.mTempStateStack[i];
                ++n2;
            }
            this.mStateStackTopIndex = n2 - 1;
            if (this.mDbg) {
                this.mSm.log("moveTempStackToStateStack: X mStateStackTop=" + this.mStateStackTopIndex + ",startingIndex=" + n + ",Top=" + this.mStateStack[this.mStateStackTopIndex].state.getName());
            }
            return n;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void performTransitions(State state, Message message) {
            State state2;
            State state3 = this.mStateStack[this.mStateStackTopIndex].state;
            boolean bl = this.mSm.recordLogRec(this.mMsg) && message.obj != mSmHandlerObj;
            if (this.mLogRecords.logOnlyTransitions()) {
                if (this.mDestState != null) {
                    this.mLogRecords.add(this.mSm, this.mMsg, this.mSm.getLogRecString(this.mMsg), state, state3, this.mDestState);
                }
            } else if (bl) {
                this.mLogRecords.add(this.mSm, this.mMsg, this.mSm.getLogRecString(this.mMsg), state, state3, this.mDestState);
            }
            if ((state2 = this.mDestState) != null) {
                while (true) {
                    if (this.mDbg) {
                        this.mSm.log("handleMessage: new destination call exit/enter");
                    }
                    this.invokeExitMethods(this.setupTempStateStackWithStatesToEnter(state2));
                    this.invokeEnterMethods(this.moveTempStateStackToStateStack());
                    this.moveDeferredMessageAtFrontOfQueue();
                    if (state2 == this.mDestState) break;
                    state2 = this.mDestState;
                }
                this.mDestState = null;
            }
            if (state2 == null) return;
            if (state2 == this.mQuittingState) {
                this.mSm.onQuitting();
                this.cleanupAfterQuitting();
                return;
            } else {
                if (state2 != this.mHaltingState) return;
                this.mSm.onHalting();
                return;
            }
        }

        /*
         * Unable to fully structure code
         */
        private final State processMsg(Message var1_1) {
            block4: {
                var2_2 = this.mStateStack[this.mStateStackTopIndex];
                if (this.mDbg) {
                    this.mSm.log("processMsg: " + var2_2.state.getName());
                }
                if (!this.isQuit(var1_1)) ** GOTO lbl11
                this.transitionTo(this.mQuittingState);
lbl6:
                // 3 sources

                while (var2_2 != null) {
                    return var2_2.state;
                }
                break block4;
lbl-1000:
                // 1 sources

                {
                    if (this.mDbg) {
                        this.mSm.log("processMsg: " + var2_2.state.getName());
                    }
lbl11:
                    // 4 sources

                    if (var2_2.state.processMessage(var1_1)) ** GOTO lbl6
                    ** while ((var2_2 = var2_2.parentStateInfo) != null)
                }
lbl13:
                // 1 sources

                this.mSm.unhandledMessage(var1_1);
                ** GOTO lbl6
            }
            return null;
        }

        private final void quit() {
            if (this.mDbg) {
                this.mSm.log("quit:");
            }
            this.sendMessage(this.obtainMessage(-1, mSmHandlerObj));
        }

        private final void quitNow() {
            if (this.mDbg) {
                this.mSm.log("quitNow:");
            }
            this.sendMessageAtFrontOfQueue(this.obtainMessage(-1, mSmHandlerObj));
        }

        private final void setDbg(boolean bl) {
            this.mDbg = bl;
        }

        private final void setInitialState(State state) {
            if (this.mDbg) {
                this.mSm.log("setInitialState: initialState=" + state.getName());
            }
            this.mInitialState = state;
        }

        private final void setupInitialStateStack() {
            if (this.mDbg) {
                this.mSm.log("setupInitialStateStack: E mInitialState=" + this.mInitialState.getName());
            }
            StateInfo stateInfo = this.mStateInfo.get(this.mInitialState);
            this.mTempStateStackCount = 0;
            while (stateInfo != null) {
                this.mTempStateStack[this.mTempStateStackCount] = stateInfo;
                stateInfo = stateInfo.parentStateInfo;
                this.mTempStateStackCount = 1 + this.mTempStateStackCount;
            }
            this.mStateStackTopIndex = -1;
            this.moveTempStateStackToStateStack();
        }

        private final StateInfo setupTempStateStackWithStatesToEnter(State state) {
            this.mTempStateStackCount = 0;
            StateInfo stateInfo = this.mStateInfo.get(state);
            do {
                StateInfo[] stateInfoArray = this.mTempStateStack;
                int n = this.mTempStateStackCount;
                this.mTempStateStackCount = n + 1;
                stateInfoArray[n] = stateInfo;
            } while ((stateInfo = stateInfo.parentStateInfo) != null && !stateInfo.active);
            if (this.mDbg) {
                this.mSm.log("setupTempStateStackWithStatesToEnter: X mTempStateStackCount=" + this.mTempStateStackCount + ",curStateInfo: " + stateInfo);
            }
            return stateInfo;
        }

        private final void transitionTo(IState iState) {
            this.mDestState = (State)iState;
            if (this.mDbg) {
                this.mSm.log("transitionTo: destState=" + this.mDestState.getName());
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public final void handleMessage(Message message) {
            block8: {
                block5: {
                    State state;
                    block7: {
                        block6: {
                            if (this.mHasQuit) break block5;
                            if (this.mDbg) {
                                this.mSm.log("handleMessage: E msg.what=" + message.what);
                            }
                            this.mMsg = message;
                            if (!this.mIsConstructionCompleted) break block6;
                            state = this.processMsg(message);
                            break block7;
                        }
                        if (this.mIsConstructionCompleted || this.mMsg.what != -2 || this.mMsg.obj != mSmHandlerObj) break block8;
                        this.mIsConstructionCompleted = true;
                        this.invokeEnterMethods(0);
                        state = null;
                    }
                    this.performTransitions(state, message);
                    if (this.mDbg && this.mSm != null) {
                        this.mSm.log("handleMessage: X");
                    }
                }
                return;
            }
            throw new RuntimeException("StateMachine.handleMessage: The start method not called, received msg: " + message);
        }

        private class HaltingState
        extends State {
            private HaltingState() {
            }

            @Override
            public boolean processMessage(Message message) {
                SmHandler.this.mSm.haltedProcessMessage(message);
                return true;
            }
        }

        private class QuittingState
        extends State {
            private QuittingState() {
            }

            @Override
            public boolean processMessage(Message message) {
                return false;
            }
        }

        private class StateInfo {
            boolean active;
            StateInfo parentStateInfo;
            State state;

            private StateInfo() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public String toString() {
                String string2;
                StringBuilder stringBuilder = new StringBuilder().append("state=").append(this.state.getName()).append(",active=").append(this.active).append(",parent=");
                if (this.parentStateInfo == null) {
                    string2 = "null";
                    return stringBuilder.append(string2).toString();
                }
                string2 = this.parentStateInfo.state.getName();
                return stringBuilder.append(string2).toString();
            }
        }
    }
}

