/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.multiwaveview;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;

public class TargetDrawable {
    private static final boolean DEBUG = false;
    public static final int[] STATE_ACTIVE = new int[]{16842910, 16842914};
    public static final int[] STATE_FOCUSED;
    public static final int[] STATE_INACTIVE;
    private static final String TAG = "TargetDrawable";
    private float mAlpha = 1.0f;
    private Drawable mDrawable;
    private boolean mEnabled = true;
    private float mPositionX = 0.0f;
    private float mPositionY = 0.0f;
    private final int mResourceId;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private float mTranslationX = 0.0f;
    private float mTranslationY = 0.0f;

    static {
        STATE_INACTIVE = new int[]{16842910, -16842914};
        STATE_FOCUSED = new int[]{16842910, -16842914, 16842908};
    }

    public TargetDrawable(Resources resources, int n) {
        this.mResourceId = n;
        this.setDrawable(resources, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public TargetDrawable(TargetDrawable targetDrawable) {
        this.mResourceId = targetDrawable.mResourceId;
        Drawable drawable2 = targetDrawable.mDrawable != null ? targetDrawable.mDrawable.mutate() : null;
        this.mDrawable = drawable2;
        this.resizeDrawables();
        this.setState(STATE_INACTIVE);
    }

    private void resizeDrawables() {
        if (this.mDrawable instanceof StateListDrawable) {
            StateListDrawable stateListDrawable = (StateListDrawable)this.mDrawable;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < stateListDrawable.getStateCount(); ++i) {
                Drawable drawable2 = stateListDrawable.getStateDrawable(i);
                n = Math.max(n, drawable2.getIntrinsicWidth());
                n2 = Math.max(n2, drawable2.getIntrinsicHeight());
            }
            stateListDrawable.setBounds(0, 0, n, n2);
            for (int i = 0; i < stateListDrawable.getStateCount(); ++i) {
                stateListDrawable.getStateDrawable(i).setBounds(0, 0, n, n2);
            }
        } else if (this.mDrawable != null) {
            this.mDrawable.setBounds(0, 0, this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
        }
    }

    public void draw(Canvas canvas) {
        if (this.mDrawable == null || !this.mEnabled) {
            return;
        }
        canvas.save(1);
        canvas.scale(this.mScaleX, this.mScaleY, this.mPositionX, this.mPositionY);
        canvas.translate(this.mTranslationX + this.mPositionX, this.mTranslationY + this.mPositionY);
        canvas.translate(-0.5f * (float)this.getWidth(), -0.5f * (float)this.getHeight());
        this.mDrawable.setAlpha(Math.round(255.0f * this.mAlpha));
        this.mDrawable.draw(canvas);
        canvas.restore();
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public int getHeight() {
        if (this.mDrawable != null) {
            return this.mDrawable.getIntrinsicHeight();
        }
        return 0;
    }

    public float getPositionX() {
        return this.mPositionX;
    }

    public float getPositionY() {
        return this.mPositionY;
    }

    public int getResourceId() {
        return this.mResourceId;
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public int getWidth() {
        if (this.mDrawable != null) {
            return this.mDrawable.getIntrinsicWidth();
        }
        return 0;
    }

    public float getX() {
        return this.mTranslationX;
    }

    public float getY() {
        return this.mTranslationY;
    }

    public boolean hasState(int[] nArray) {
        boolean bl = this.mDrawable instanceof StateListDrawable;
        boolean bl2 = false;
        if (bl) {
            int n = ((StateListDrawable)this.mDrawable).getStateDrawableIndex(nArray);
            bl2 = false;
            if (n != -1) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean isActive() {
        if (this.mDrawable instanceof StateListDrawable) {
            int[] nArray = ((StateListDrawable)this.mDrawable).getState();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != 16842908) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEnabled() {
        return this.mDrawable != null && this.mEnabled;
    }

    public void setAlpha(float f) {
        this.mAlpha = f;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDrawable(Resources resources, int n) {
        Drawable drawable2 = n == 0 ? null : resources.getDrawable(n);
        Drawable drawable3 = null;
        if (drawable2 != null) {
            drawable3 = drawable2.mutate();
        }
        this.mDrawable = drawable3;
        this.resizeDrawables();
        this.setState(STATE_INACTIVE);
    }

    public void setEnabled(boolean bl) {
        this.mEnabled = bl;
    }

    public void setPositionX(float f) {
        this.mPositionX = f;
    }

    public void setPositionY(float f) {
        this.mPositionY = f;
    }

    public void setScaleX(float f) {
        this.mScaleX = f;
    }

    public void setScaleY(float f) {
        this.mScaleY = f;
    }

    public void setState(int[] nArray) {
        if (this.mDrawable instanceof StateListDrawable) {
            ((StateListDrawable)this.mDrawable).setState(nArray);
        }
    }

    public void setX(float f) {
        this.mTranslationX = f;
    }

    public void setY(float f) {
        this.mTranslationY = f;
    }
}

