/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.view;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.view.mxICellEditor;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Writer;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLWriter;
import javax.swing.text.html.MinimalHTMLWriter;

public class mxCellEditor
implements mxICellEditor {
    private static final String CANCEL_EDITING = "cancel-editing";
    private static final String INSERT_BREAK = "insert-break";
    private static final String SUBMIT_TEXT = "submit-text";
    public static int DEFAULT_MIN_WIDTH = 100;
    public static int DEFAULT_MIN_HEIGHT = 60;
    public static double DEFAULT_MINIMUM_EDITOR_SCALE = 1.0;
    protected mxGraphComponent graphComponent;
    protected double minimumEditorScale = DEFAULT_MINIMUM_EDITOR_SCALE;
    protected int minimumWidth = DEFAULT_MIN_WIDTH;
    protected int minimumHeight = DEFAULT_MIN_HEIGHT;
    protected transient Object editingCell;
    protected transient EventObject trigger;
    protected transient JScrollPane scrollPane;
    protected transient JTextArea textArea;
    protected transient JEditorPane editorPane;
    protected boolean extractHtmlBody = true;
    protected boolean replaceLinefeeds = true;
    protected boolean shiftEnterSubmitsText = false;
    transient Object editorEnterActionMapKey;
    transient Object textEnterActionMapKey;
    transient KeyStroke escapeKeystroke = KeyStroke.getKeyStroke("ESCAPE");
    transient KeyStroke enterKeystroke = KeyStroke.getKeyStroke("ENTER");
    transient KeyStroke shiftEnterKeystroke = KeyStroke.getKeyStroke("shift ENTER");
    protected AbstractAction cancelEditingAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            mxCellEditor.this.stopEditing(true);
        }
    };
    protected AbstractAction textSubmitAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            mxCellEditor.this.stopEditing(false);
        }
    };

    public mxCellEditor(mxGraphComponent mxGraphComponent2) {
        this.graphComponent = mxGraphComponent2;
        this.textArea = new JTextArea();
        this.textArea.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.textArea.setOpaque(false);
        this.editorPane = new JEditorPane();
        this.editorPane.setOpaque(false);
        this.editorPane.setBackground(new Color(0, 0, 0, 0));
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditorKit(new NoLinefeedHtmlEditorKit());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.setVisible(false);
        this.scrollPane.setOpaque(false);
        this.editorPane.getActionMap().put(CANCEL_EDITING, this.cancelEditingAction);
        this.textArea.getActionMap().put(CANCEL_EDITING, this.cancelEditingAction);
        this.editorPane.getActionMap().put(SUBMIT_TEXT, this.textSubmitAction);
        this.textArea.getActionMap().put(SUBMIT_TEXT, this.textSubmitAction);
        this.editorEnterActionMapKey = this.editorPane.getInputMap().get(this.enterKeystroke);
        this.textEnterActionMapKey = this.editorPane.getInputMap().get(this.enterKeystroke);
    }

    public boolean isExtractHtmlBody() {
        return this.extractHtmlBody;
    }

    public void setExtractHtmlBody(boolean bl) {
        this.extractHtmlBody = bl;
    }

    public boolean isReplaceHtmlLinefeeds() {
        return this.replaceLinefeeds;
    }

    public void setReplaceHtmlLinefeeds(boolean bl) {
        this.replaceLinefeeds = bl;
    }

    public boolean isShiftEnterSubmitsText() {
        return this.shiftEnterSubmitsText;
    }

    public void setShiftEnterSubmitsText(boolean bl) {
        this.shiftEnterSubmitsText = bl;
    }

    protected void configureActionMaps() {
        InputMap inputMap = this.editorPane.getInputMap();
        InputMap inputMap2 = this.textArea.getInputMap();
        inputMap.put(this.escapeKeystroke, this.cancelEditingAction);
        inputMap2.put(this.escapeKeystroke, this.cancelEditingAction);
        if (this.graphComponent.isEnterStopsCellEditing()) {
            inputMap.put(this.shiftEnterKeystroke, this.editorEnterActionMapKey);
            inputMap2.put(this.shiftEnterKeystroke, this.textEnterActionMapKey);
            inputMap.put(this.enterKeystroke, SUBMIT_TEXT);
            inputMap2.put(this.enterKeystroke, SUBMIT_TEXT);
        } else {
            inputMap.put(this.enterKeystroke, this.editorEnterActionMapKey);
            inputMap2.put(this.enterKeystroke, this.textEnterActionMapKey);
            if (this.isShiftEnterSubmitsText()) {
                inputMap.put(this.shiftEnterKeystroke, SUBMIT_TEXT);
                inputMap2.put(this.shiftEnterKeystroke, SUBMIT_TEXT);
            } else {
                inputMap.remove(this.shiftEnterKeystroke);
                inputMap2.remove(this.shiftEnterKeystroke);
            }
        }
    }

    public Component getEditor() {
        if (this.textArea.getParent() != null) {
            return this.textArea;
        }
        if (this.editingCell != null) {
            return this.editorPane;
        }
        return null;
    }

    protected boolean useLabelBounds(mxCellState mxCellState2) {
        mxIGraphModel mxIGraphModel2 = mxCellState2.getView().getGraph().getModel();
        mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(mxCellState2.getCell());
        return mxGeometry2 != null && mxGeometry2.getOffset() != null && !mxGeometry2.isRelative() && (mxGeometry2.getOffset().getX() != 0.0 || mxGeometry2.getOffset().getY() != 0.0) || mxIGraphModel2.isEdge(mxCellState2.getCell());
    }

    public Rectangle getEditorBounds(mxCellState mxCellState2, double d) {
        mxIGraphModel mxIGraphModel2 = mxCellState2.getView().getGraph().getModel();
        Rectangle rectangle = null;
        if (this.useLabelBounds(mxCellState2)) {
            rectangle = mxCellState2.getLabelBounds().getRectangle();
            rectangle.height += 10;
        } else {
            rectangle = mxCellState2.getRectangle();
        }
        if (mxIGraphModel2.isVertex(mxCellState2.getCell())) {
            String string = mxUtils.getString(mxCellState2.getStyle(), mxConstants.STYLE_LABEL_POSITION, "center");
            if (string.equals("left")) {
                rectangle.x = (int)((double)rectangle.x - mxCellState2.getWidth());
            } else if (string.equals("right")) {
                rectangle.x = (int)((double)rectangle.x + mxCellState2.getWidth());
            }
            String string2 = mxUtils.getString(mxCellState2.getStyle(), mxConstants.STYLE_VERTICAL_LABEL_POSITION, "middle");
            if (string2.equals("top")) {
                rectangle.y = (int)((double)rectangle.y - mxCellState2.getHeight());
            } else if (string2.equals("bottom")) {
                rectangle.y = (int)((double)rectangle.y + mxCellState2.getHeight());
            }
        }
        rectangle.setSize((int)Math.max(rectangle.getWidth(), (double)Math.round((double)this.minimumWidth * d)), (int)Math.max(rectangle.getHeight(), (double)Math.round((double)this.minimumHeight * d)));
        return rectangle;
    }

    @Override
    public void startEditing(Object object, EventObject eventObject) {
        mxCellState mxCellState2;
        if (this.editingCell != null) {
            this.stopEditing(true);
        }
        if ((mxCellState2 = this.graphComponent.getGraph().getView().getState(object)) != null) {
            this.editingCell = object;
            this.trigger = eventObject;
            double d = Math.max(this.minimumEditorScale, this.graphComponent.getGraph().getView().getScale());
            this.scrollPane.setBounds(this.getEditorBounds(mxCellState2, d));
            this.scrollPane.setVisible(true);
            String string = this.getInitialValue(mxCellState2, eventObject);
            JTextComponent jTextComponent = null;
            if (this.graphComponent.getGraph().isHtmlLabel(object)) {
                if (this.isExtractHtmlBody()) {
                    string = mxUtils.getBodyMarkup(string, this.isReplaceHtmlLinefeeds());
                }
                this.editorPane.setDocument(mxUtils.createHtmlDocumentObject(mxCellState2.getStyle(), d));
                this.editorPane.setText(string);
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.setOpaque(false);
                jPanel.add((Component)this.editorPane, "Center");
                this.scrollPane.setViewportView(jPanel);
                jTextComponent = this.editorPane;
            } else {
                this.textArea.setFont(mxUtils.getFont(mxCellState2.getStyle(), d));
                Color color = mxUtils.getColor(mxCellState2.getStyle(), mxConstants.STYLE_FONTCOLOR, Color.black);
                this.textArea.setForeground(color);
                this.textArea.setText(string);
                this.scrollPane.setViewportView(this.textArea);
                jTextComponent = this.textArea;
            }
            this.graphComponent.getGraphControl().add((Component)this.scrollPane, 0);
            if (this.isHideLabel(mxCellState2)) {
                this.graphComponent.redraw(mxCellState2);
            }
            jTextComponent.revalidate();
            jTextComponent.requestFocusInWindow();
            jTextComponent.selectAll();
            this.configureActionMaps();
        }
    }

    protected boolean isHideLabel(mxCellState mxCellState2) {
        return true;
    }

    @Override
    public void stopEditing(boolean bl) {
        if (this.editingCell != null) {
            this.scrollPane.transferFocusUpCycle();
            Object object = this.editingCell;
            this.editingCell = null;
            if (!bl) {
                EventObject eventObject = this.trigger;
                this.trigger = null;
                this.graphComponent.labelChanged(object, this.getCurrentValue(), eventObject);
            } else {
                mxCellState mxCellState2 = this.graphComponent.getGraph().getView().getState(object);
                this.graphComponent.redraw(mxCellState2);
            }
            if (this.scrollPane.getParent() != null) {
                this.scrollPane.setVisible(false);
                this.scrollPane.getParent().remove(this.scrollPane);
            }
            this.graphComponent.requestFocusInWindow();
        }
    }

    protected String getInitialValue(mxCellState mxCellState2, EventObject eventObject) {
        return this.graphComponent.getEditingValue(mxCellState2.getCell(), eventObject);
    }

    public String getCurrentValue() {
        String string;
        if (this.textArea.getParent() != null) {
            string = this.textArea.getText();
        } else {
            string = this.editorPane.getText();
            if (this.isExtractHtmlBody()) {
                string = mxUtils.getBodyMarkup(string, this.isReplaceHtmlLinefeeds());
            }
        }
        return string;
    }

    @Override
    public Object getEditingCell() {
        return this.editingCell;
    }

    public double getMinimumEditorScale() {
        return this.minimumEditorScale;
    }

    public void setMinimumEditorScale(double d) {
        this.minimumEditorScale = d;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(int n) {
        this.minimumWidth = n;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeight(int n) {
        this.minimumHeight = n;
    }

    class NoLinefeedHtmlWriter
    extends HTMLWriter {
        public NoLinefeedHtmlWriter(Writer writer, HTMLDocument hTMLDocument, int n, int n2) {
            super(writer, hTMLDocument, n, n2);
        }

        @Override
        protected void setLineLength(int n) {
            super.setLineLength(n);
        }
    }

    class NoLinefeedHtmlEditorKit
    extends HTMLEditorKit {
        NoLinefeedHtmlEditorKit() {
        }

        @Override
        public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
            if (document instanceof HTMLDocument) {
                NoLinefeedHtmlWriter noLinefeedHtmlWriter = new NoLinefeedHtmlWriter(writer, (HTMLDocument)document, n, n2);
                noLinefeedHtmlWriter.setLineLength(Integer.MAX_VALUE);
                noLinefeedHtmlWriter.write();
            } else if (document instanceof StyledDocument) {
                MinimalHTMLWriter minimalHTMLWriter = new MinimalHTMLWriter(writer, (StyledDocument)document, n, n2);
                minimalHTMLWriter.write();
            } else {
                super.write(writer, document, n, n2);
            }
        }
    }
}

