package de.upb.pga3.ate;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 *
 * This class is used to generate objects for each test case
 *
 * @author Abhinav
 * @author Arjya
 */
public class Generator {
	File root;
	ArrayList<TestCase> testCasesList = new ArrayList<>();

	String level;
	boolean isComparison = false;
	boolean isAllMode = false;
	File analyzedApp;
	File result;
	List<String> expResult = new ArrayList<String>();
	String nonNative = "";

	/**
	 * This method calls the genTestcase() function and then returns list of all
	 * the test cases. {@link Generator}.
	 *
	 * @return The created list of all test cases.
	 */
	public ArrayList<TestCase> generateTestCases() {

		genTestCase();
		return this.testCasesList;

	}

	/**
	 * This method navigates through directory provided by the user and then
	 * create an object of TestCase for every test it encounters. It also reads
	 * the input provided by user as expected results. {@link Generator}.
	 *
	 *
	 */
	public void genTestCase() {
		final String pathExt = AutomatedTestGUI.pathFile.toString();
		final Logger LOGGER = LogManager.getLogger(Generator.class);
		final File[] root = new File(pathExt).listFiles();

		for (int x = 0; x < root.length; ++x) {

			final String folderPath = root[x].getAbsolutePath().toString();

			if (folderPath.contains("Level1")) {

				final File[] foldersLevel1 = new File(root[x].getAbsolutePath().toString()).listFiles();

				for (int i = 0; i < foldersLevel1.length; ++i) {

					final File[] files = new File(foldersLevel1[i].getAbsolutePath().toString()).listFiles();

					for (int a = 0; a < files.length; ++a) {

						if (files[a].getAbsolutePath().endsWith(".apk")
								& !files[a].getAbsolutePath().endsWith("comp.apk")) {

							this.analyzedApp = files[a];

						}

						else if (files[a].getAbsolutePath().endsWith(".pa2")
								|| files[a].getAbsolutePath().endsWith("comp.apk")) {

							this.isComparison = true;
							this.result = files[a];

						} else if (files[a].getAbsolutePath().endsWith(".txt")) {

							final Path path = FileSystems.getDefault().getPath(files[a].getAbsolutePath());
							try {
								this.expResult = Files.readAllLines(path);

							} catch (final Exception name) {

							}
						} else {

							LOGGER.error("file type not supported" + files[a]);
						}

					}

					final TestCase tc = new TestCase("1", this.isComparison, this.isAllMode, this.analyzedApp,
							this.result, this.nonNative, this.expResult);
					this.testCasesList.add(tc);

					this.isComparison = false;
					this.result = null;

				}

			}

			else if (folderPath.contains("Level2a")) {

				final File[] foldersLevel2a = new File(root[x].getAbsolutePath().toString()).listFiles();

				for (int i = 0; i < foldersLevel2a.length; ++i) {

					final File[] files = new File(foldersLevel2a[i].getAbsolutePath().toString()).listFiles();

					for (int a = 0; a < files.length; ++a) {

						if (files[a].getAbsolutePath().endsWith(".apk")
								& !files[a].getAbsolutePath().endsWith("comp.apk")) {

							this.analyzedApp = files[a];

						}

						else if (files[a].getAbsolutePath().endsWith(".pa2")
								|| files[a].getAbsolutePath().endsWith("comp.apk")) {

							this.isComparison = true;
							this.result = files[a];

						} else if (files[a].getAbsolutePath().endsWith(".txt")) {

							final Path path = FileSystems.getDefault().getPath(files[a].getAbsolutePath());
							try {
								this.expResult = Files.readAllLines(path);

							} catch (final Exception name) {

							}
						} else {

							LOGGER.error("file type not supported" + files[a]);
						}

					}

					final TestCase tc = new TestCase("2a", this.isComparison, this.isAllMode, this.analyzedApp,
							this.result, this.nonNative, this.expResult);
					this.testCasesList.add(tc);

					this.isComparison = false;
					this.result = null;

				}

			} else if (folderPath.contains("Level2b")) {

				final File[] root2b = new File(root[x].getAbsolutePath().toString()).listFiles();

				for (int b = 0; b < root2b.length; ++b) {

					final String rootPath = root2b[b].getAbsolutePath().toString();

					if (rootPath.contains("APP")) {

						final File[] foldersLevel2bAPP = new File(root2b[b].getAbsolutePath().toString()).listFiles();

						for (int i = 0; i < foldersLevel2bAPP.length; ++i) {

							final File[] files = new File(foldersLevel2bAPP[i].getAbsolutePath().toString())
									.listFiles();

							for (int a = 0; a < files.length; ++a) {

								if (files[a].getAbsolutePath().endsWith(".apk")
										& !files[a].getAbsolutePath().endsWith("nn.apk")
										& !files[a].getAbsolutePath().endsWith("comp.apk")) {

									this.analyzedApp = files[a];

								}

								else if (files[a].getAbsolutePath().endsWith(".pa2")
										|| files[a].getAbsolutePath().endsWith("comp.apk")) {

									this.isComparison = true;
									this.result = files[a];

								} else if (files[a].getAbsolutePath().endsWith("nn.apk")) {
									final String nnApender = "\"" + files[a].getAbsolutePath() + "\"";
									this.nonNative = this.nonNative + "-" + nnApender;

								} else if (files[a].getAbsolutePath().endsWith(".txt")) {

									final Path path = FileSystems.getDefault().getPath(files[a].getAbsolutePath());
									try {
										this.expResult = Files.readAllLines(path);

									} catch (final Exception name) {

									}
								} else {
									LOGGER.error("file type not supported" + files[a]);
								}

							}

							final TestCase tc = new TestCase("2b", this.isComparison, this.isAllMode, this.analyzedApp,
									this.result, this.nonNative, this.expResult);
							this.testCasesList.add(tc);

							this.isComparison = false;
							this.result = null;
							this.nonNative = "";

						}

					}

					else if (rootPath.contains("ALL")) {

						final File[] foldersLevel2bALL = new File(root2b[b].getAbsolutePath().toString()).listFiles();

						for (int i = 0; i < foldersLevel2bALL.length; ++i) {

							final File[] files = new File(foldersLevel2bALL[i].getAbsolutePath().toString())
									.listFiles();

							for (int a = 0; a < files.length; ++a) {

								if (files[a].getAbsolutePath().endsWith(".apk")
										& !files[a].getAbsolutePath().endsWith("nn.apk")
										& !files[a].getAbsolutePath().endsWith("comp.apk")) {

									this.analyzedApp = files[a];

								}

								else if (files[a].getAbsolutePath().endsWith(".pa2")
										|| files[a].getAbsolutePath().endsWith("comp.apk")) {

									this.isComparison = true;
									this.result = files[a];

								} else if (files[a].getAbsolutePath().endsWith("nn.apk")) {
									final String nnApender = "\"" + files[a].getAbsolutePath() + "\"";
									this.nonNative = this.nonNative + "-" + nnApender;

								} else if (files[a].getAbsolutePath().endsWith(".txt")) {

									final Path path = FileSystems.getDefault().getPath(files[a].getAbsolutePath());
									try {
										this.expResult = Files.readAllLines(path);

									} catch (final Exception name) {

									}
								} else {
									LOGGER.error("file type not supported" + files[a]);
								}

							}

							this.isAllMode = true;

							final TestCase tc = new TestCase("2b", this.isComparison, this.isAllMode, this.analyzedApp,
									this.result, this.nonNative, this.expResult);
							this.testCasesList.add(tc);

							this.isComparison = false;
							this.result = null;
							this.nonNative = "";

						}

					} else {
						LOGGER.error("file type not supported");
					}

				}

			} else {
				LOGGER.error("file type not supported");
			}

		}
	}

}
