package de.upb.pga3.panda2.client.cmdline;

import java.io.File;
import java.util.HashMap;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import de.upb.pga3.panda2.client.core.Client;

/**
 *
 * Class for parsing the HTML String for showing the textual result.
 *
 * @author Sriram
 *
 */
public class HtmlParser {

	static final Logger LOGGER = LogManager.getLogger(HtmlParser.class);

	/**
	 * Method for parsing the HTML String and printing the String in the command
	 * line output.
	 *
	 * @param textualResult
	 *            The String represents the textual result value.
	 */
	public static void parse(final String textualResult, final boolean testScenario) {
		try {
			final StringBuilder output = new StringBuilder();
			final String nextLineCharacter = "\n";
			final String tabSpaceCharacter = "\t";
			final String seperatorString = "-----";
			if (textualResult != null) {
				final File input = new File(textualResult);

				// Condition is true for LEVEL1 and LEVEL2B
				if (input.exists() && !input.isDirectory()) {

					final HashMap<String, String> colorLegendMapping = new HashMap<>();
					colorLegendMapping.put("#007f22", "REQUIRED");
					colorLegendMapping.put("#0006fd", "MAY BE REQUIRED");
					colorLegendMapping.put("#927a3a", "UNUSED");
					colorLegendMapping.put("#ff7500", "MAYBE_MISSING");
					colorLegendMapping.put("#ff0000", "MISSING");

					final Document doc = Jsoup.parse(input, "UTF-8");
					output.append(doc.title() + nextLineCharacter);

					final Element legend = doc.select("div.legend").first();
					if (legend != null && !testScenario) {
						output.append(legend.text() + nextLineCharacter);
					}

					final Element stats = doc.select("div.stats").first();
					if (stats != null) {
						output.append("STATISTICS:" + nextLineCharacter);

						for (final Element row : stats.select("tr")) {
							final Elements tdatas = row.select("td:not([rowspan])");
							final Elements tstrongdatas = row.select("td:not([rowspan]) strong");
							output.append(tdatas.get(0).text()
									+ " "
									+ (tstrongdatas != null && tstrongdatas.size() > 0 ? tstrongdatas.get(0).text()
											: "") + nextLineCharacter);
							if (tdatas.get(0).text() != null && !tdatas.get(0).text().contains("worthy")) {
								final Elements tfontdatas = row.select("td:not([rowspan]) font");
								for (final Element tFontData : tfontdatas) {
									if (!tFontData.attr("color").isEmpty()) {
										output.append(tFontData.text() + tabSpaceCharacter
												+ colorLegendMapping.get(tFontData.attr("color")) + nextLineCharacter);
									}
								}
							}
						}
					}

					final Elements allElements = doc.select("*");
					if (allElements != null) {
						for (final Element element : allElements) {
							if (!element.className().isEmpty()
									&& (element.className().equals("plus") || element.className().equals("spacer"))) {
								Element node = element.nextElementSibling();
								while (node != null && !node.tagName().equalsIgnoreCase("strong")) {
									node = node.nextElementSibling();
								}
								if (node != null) {
									output.append(seperatorString + node.text() + seperatorString + nextLineCharacter);
								}
							}
							if (!element.className().isEmpty() && element.className().equals("premissions")) {
								final Elements permissionsSelect = element.select("font");
								for (final Element row : permissionsSelect) {
									String permission = "";
									if (!row.attr("title").isEmpty()) {
										permission = row.attr("title");
									}
									output.append(row.text() + " " + "(" + permission + ")" + nextLineCharacter);
								}
							}
						}
					}
				} else {
					// Logic is for Level2A
					final Document doc = Jsoup.parse(textualResult);

					final Element stats = doc.select("div.stats").first();
					if (stats != null) {
						output.append("STATISTICS:" + nextLineCharacter);

						for (final Element row : stats.select("tr table tr")) {
							final Elements tdatas = row.select("td");
							final Elements tstrongdatas = row.select("td strong");
							output.append((tdatas != null && tdatas.size() > 0 ? tdatas.get(0).text() : "")
									+ (tstrongdatas != null && tstrongdatas.size() > 0 ? tstrongdatas.get(0).text()
											: "") + nextLineCharacter);
						}
					}

					final Element legend = doc.select("div.legend").first();
					if (legend != null) {
						output.append(legend.text() + nextLineCharacter);
					}

					Integer columnSpan = 0;
					final StringBuilder header = new StringBuilder();
					for (final Element table : doc.select("table[id=level2a]")) {
						for (final Element row : table.select("tbody tr th")) {
							if (!row.attr("colspan").isEmpty()) {
								columnSpan = Integer.parseInt(row.attr("colspan"));
								header.append(row.text() + nextLineCharacter);
							} else {
								header.append(row.text() + seperatorString);
							}
						}
						if (header.toString() != null) {
							output.append(header.toString() + nextLineCharacter);
						}
						for (final Element row : table.select("tr:gt(1)")) {
							final Elements tdatas = row.select("td:not([rowspan])");
							if (columnSpan == 2) {
								output.append(tdatas.get(0).text() + " (SOURCE)" + seperatorString
										+ tdatas.get(1).text() + " (TARGET)" + nextLineCharacter);
							} else if (columnSpan == 3 && tdatas.size() >= 3) {
								output.append(tdatas.get(0).text() + " (SOURCE)" + seperatorString
										+ tdatas.get(1).text() + " (TARGET)" + seperatorString + tdatas.get(2).text()
										+ " (TARGET)" + nextLineCharacter);
							}
						}
					}
				}
				if (!testScenario) {
					Client.print(output.toString());
				}
				LOGGER.info("Result was parsed successfully");
			} else {
				throw new NullPointerException("HTML String for the textual result is null");
			}
		} catch (final Exception ex) {
			ex.printStackTrace();
			LOGGER.error("Exception while parsing the HTML String for the textual result for Command Line."
					+ ex.getMessage());
		}
	}
}
