package de.upb.pga3.panda2.client.core;

import java.util.List;

import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.core.datastructures.Message;

/**
 * This Class represents the core business logic from GUI perspective by
 * extending the abstract class Client.
 *
 * @author Sriram
 */
@SuppressWarnings("unused")
public class ClientGUI extends Client {

	/**
	 * Constructor without parameter.
	 *
	 * Uses the Super Constructor without parameters of the super class
	 *
	 * It also creates the required user object within the super constructor
	 * method e.g. the {@link UserInput}
	 */
	public ClientGUI() {
		super();
	}

	/**
	 * Constructor with parameter. Uses the super class Constructor with
	 * parameters. It also creates the required user object within the method
	 * e.g. the {@link UserInput}
	 *
	 * @param level
	 *            Represents the Level selected by the user.
	 * @param levelSpecificMode
	 *            Represents the mode specific to the level by the user. Value
	 *            of this value will be null for Level1 and Level2a.
	 * @param mode
	 *            Represents the Mode selected by the user.
	 *
	 *
	 */
	/*
	 * public ClientGUI(final Level level, final LevelSpecificMode
	 * levelSpecificMode, final Mode mode) { super(level, levelSpecificMode,
	 * mode); }
	 */

	/**
	 * Method for saving the result and persisting the instance of ClientGUI
	 * class from summary mode to comparison mode.
	 *
	 * @param path
	 *            String value which represents the file location where the
	 *            analysis result is going to be saved.
	 * @return clientGUI, instance of the {@code ClientGUI} class.
	 */

	public ClientGUI proceedToComparisonMode(final String path) {
		return null;
	}

	/**
	 * Method added for showing the Messages as HTML String Format. Based on the
	 * GUI decision, this method can be later used or not required.
	 *
	 * @return String
	 */
	public String convertMessagesToHTMLString() {
		final AnalysisResult anaResult = getAnalysisResult();
		String messagesString = "<strong>Messages:</strong> " + "<br />\n";
		if (anaResult != null) {
			int messageCount = 0;
			for (final Message message : anaResult.getMessages()) {
				messageCount++;
				messagesString = messagesString + "\t<li><strong>Message:" + messageCount + "</strong> " + "<br />\n";
				messagesString = messagesString + "\n Message Type:\n" + message.getType().toString() + "<br />\n";
				messagesString = messagesString + "\n Message Body \n" + message.getBody() + "<br />\n";
				messagesString = messagesString + "\n ---Message Title--- \n" + message.getTitle() + "<br />\n";
			}
		}
		return messagesString;
	}

	/**
	 * Method for fetching the list of Detail Levels based on the user input
	 * selection.
	 *
	 * @return instance of List<String>, Detail Levels based on the analysis
	 *         result as list of String values.
	 *
	 */
	public List<String> getDefaultDetailLevels(final String level) {
		return null;
	}

	/**
	 * Method for fetching the filtered textual result as a String. Currently
	 * used as abstract method.
	 *
	 * @param detailLevel
	 *            the instance of implemented classes of the DetailLevel
	 *            interface
	 * @param resultFilter
	 *            Result filters as the instances of the list of String.
	 * @return textualResult, represents the analysis textual result as instance
	 *         of the String class
	 */
	@Override
	public String filterTextViewResult(final DetailLevel detailLevel, final List<String> resultFilter) {
		return null;
	}

	@Override
	public String filterGraphicalViewResult(final DetailLevel detailLevel, final List<String> resultFilter) {
		return null;
	}

	/*
	 *
	 * Not implemented as the following methods are not required now.
	 *
	 *
	 * public void showTextualViewResult(final String textualAnalysisResult) {
	 *
	 * }
	 *
	 * public void showGraphicalViewResult(final String graphicalAnalysisResult)
	 * {
	 *
	 * }
	 *
	 * public void showMessageViewResult(final Collection<Message> messages) {
	 *
	 * }
	 */

}
