package de.upb.pga3.panda2.client.core;

import de.upb.pga3.panda2.client.core.datastructures.UIMessage;
import de.upb.pga3.panda2.client.core.datastructures.UIMessageType;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.utilities.Constants;
import de.upb.pga3.panda2.utilities.CustomSerializer;

/**
 * Class for saving the analysis result.
 *
 * @author Sriram
 */
public class ResultStorer {

	/**
	 * Method for saving the analysis result on the given path.
	 *
	 * @param analysisResult
	 *            The instance of the AnalysisResult class.
	 * @param path
	 *            The String value which contains the user desired path for
	 *            saving the result.
	 * @return uiMessage, instance of {@code UIMessage} class.
	 */
	public static UIMessage storeResult(final AnalysisResult analysisResult, final String path) {
		UIMessage uiMessage;
		try {
			CustomSerializer.writeObject(path, analysisResult);
			// DefaultJavaSerializer.writeObject(path, analysisResult);
			Client.print(Constants.SAVE_RESULT_SUCCESS);
			uiMessage = new UIMessage(UIMessageType.INFO, Constants.SAVE_RESULT_SUCCESS);
		} catch (final Exception ex) {
			uiMessage = new UIMessage(UIMessageType.ERROR, Constants.SAVE_RESULT_FAILURE);
			ex.printStackTrace();
		}
		return uiMessage;

	}
}
