package de.upb.pga3.panda2.client.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import com.beust.jcommander.Parameter;

import de.upb.pga3.panda2.client.core.datastructures.LevelSpecificMode;
import de.upb.pga3.panda2.client.core.datastructures.Mode;
import de.upb.pga3.panda2.client.core.datastructures.ResultRepresentation;
import de.upb.pga3.panda2.client.core.datastructures.ResultView;
import de.upb.pga3.panda2.client.core.datastructures.ToolSpecificOption;
import de.upb.pga3.panda2.client.core.datastructures.validation.LevelSpecificModeConverter;
import de.upb.pga3.panda2.client.core.datastructures.validation.ResultRepresentationConverter;
import de.upb.pga3.panda2.client.core.datastructures.validation.ResultViewConverter;
import de.upb.pga3.panda2.client.core.datastructures.validation.ToolSpecificOptionConverter;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.utilities.Constants;

/**
 * Class which provides the variables for persisting the values of the given
 * user input and also methods for providing the functionality of the same.
 *
 * @author Sriram
 *
 */
public class UserInput {

	/*
	 * Three options/command are there in our tool using command line. User can
	 * 1. Analyze the apps, 2. They can load the previous result and view it and
	 * 3. Help options
	 */
	@Parameter(names = { "-toolopt", "-opt",
			"-option" }, description = Constants.HELP_OPTION_DESCRIPTION, converter = ToolSpecificOptionConverter.class)
	private ToolSpecificOption tsOption = ToolSpecificOption.ANALYSIS;
	@Parameter(names = { "-l", "-level" }, description = Constants.HELP_LEVEL_DESCRIPTION, required = false)
	private String level;
	@Parameter(names = { "-lm",
			"-levelmode" }, description = Constants.HELP_LEVELMODE_DESCRIPTION, required = false, converter = LevelSpecificModeConverter.class)
	private LevelSpecificMode levelSpecificMode;
	private Mode mode = Mode.SUMMARY;
	@Parameter(names = { "-i",
			"-input" }, description = Constants.HELP_INPUTAPK_DESCRIPTION, required = false, variableArity = true)
	private List<String> selectedInitialInput;
	@Parameter(names = { "-nn",
			"-nonnative" }, description = Constants.HELP_NONNATIVEAPK_DESCRIPTION, required = false, variableArity = true)
	private List<String> selectedNonNativeapps;
	@Parameter(names = { "-ci", "-compareinput" }, description = Constants.HELP_COMPAREINPUT_DESCRIPTION)
	private String selectedComparisonInput;
	@Parameter(names = { "-r",
			"-result" }, description = Constants.HELP_RESULTREP_DESCRIPTION, required = false, converter = ResultRepresentationConverter.class)
	// Following variables specific for command line inputs.
	private ResultRepresentation resultRepresentation = ResultRepresentation.VIEW;
	@Parameter(names = { "-v",
			"-view" }, description = Constants.HELP_RESULTVIEW_DESCRIPTION, required = false, converter = ResultViewConverter.class)
	private ResultView resultView = ResultView.TEXTUAL;
	@Parameter(names = { "-fp", "-filepath" }, description = Constants.HELP_SAVEORVIEWFP_DESCRIPTION, required = false)
	private String filePath;
	@Parameter(names = { "-x", "-exit", "-t",
			"-terminate" }, description = Constants.HELP_EXIT_DESCRIPTION, required = false, arity = 1)
	private boolean terminate = true;
	@Parameter(names = { "-f",
			"-filter" }, description = Constants.HELP_FILTERS_DESCRIPTION, required = false, variableArity = true)
	private List<String> userSelectedFilters;
	@Parameter(names = { "-dl",
			"-detaillevel" }, description = Constants.HELP_DETAILLEVEL_DESCRIPTION, required = false)
	private String userSelectedDetailLevel;
	@Parameter(names = { "-ts",
			"-testscenario" }, description = Constants.HELP_TESTSCENARIO_DESCRIPTION, required = false, arity = 1)
	private boolean testingScenario = false;
	@Parameter(names = { "-tstat",
			"-teststats" }, description = Constants.HELP_TESTSTATS_DESCRIPTION, required = false, arity = 1)
	private boolean showTestStatistics = true;

	private AnalysisResult previousAnalysisResult;
	private List<File> initialInputAPKFiles;
	private List<File> nonNativeAPKFiles;
	private File previousAnalysisResultFile;

	/**
	 * Constructor without parameter.
	 *
	 */
	public UserInput() {

	}

	/**
	 * Constructor with parameter.
	 *
	 * @param level
	 *            Instance of Level class.
	 * @param levelSpecificMode
	 *            Instance of LevelSpecificMode class.
	 * @param mode
	 *            Instance of Mode class.
	 */
	public UserInput(final String level, final LevelSpecificMode levelSpecificMode, final Mode mode) {
		super();
		this.level = level;
		this.levelSpecificMode = levelSpecificMode;
		this.mode = mode;
	}

	/**
	 * Get the instance of Level class which was set by the user.
	 *
	 * @return level, returns the instance of the {@code Level} class.
	 */
	public String getLevel() {
		return this.level;
	}

	/**
	 * Set the value of the Level class instance variable.
	 *
	 * @param level
	 */
	public void setLevel(final String level) {
		this.level = level;
	}

	/**
	 * Get the instance of LevelSpecificMode class which was set by the user.
	 *
	 * @return levelSpecificMode, returns the instance of the
	 *         {@code LevelSpecificMode} class.
	 */
	public LevelSpecificMode getLevelSpecificMode() {
		return this.levelSpecificMode;
	}

	/**
	 * Set the value of the LevelSpecificMode class instance variable.
	 *
	 * @param levelSpecificMode
	 */

	public void setLevelSpecificMode(final LevelSpecificMode levelSpecificMode) {
		this.levelSpecificMode = levelSpecificMode;
	}

	/**
	 * Get the instance of Mode class which was set by the user.
	 *
	 * @return mode, returns the instance of the {@code Mode} class.
	 */
	public Mode getMode() {
		return this.mode;
	}

	/**
	 * Set the value of the Mode class instance variable.
	 *
	 * @param mode
	 */
	public void setMode(final Mode mode) {
		this.mode = mode;
	}

	/**
	 * Get the user selected input apk file path as String values.
	 *
	 * @return selectedInitialInput, list of String instances.
	 */
	public List<String> getSelectedInitialInput() {
		return this.selectedInitialInput;
	}

	/**
	 * Set the user selected input apk file path as String values.
	 *
	 * @param selectedInitialInput
	 *            list of String instances.
	 */
	public void setSelectedInitialInput(final List<String> selectedInitialInput) {
		this.selectedInitialInput = selectedInitialInput;
	}

	/**
	 * Get the user selected non native apk fie path.
	 *
	 * @return selectedNonNativeapps, list of String instances.
	 */
	public List<String> getSelectedNonNativeapps() {
		return this.selectedNonNativeapps;
	}

	/**
	 * Set the user selected non native apk file path as String values.
	 *
	 * @param selectedNonNativeapps
	 *            List of String instances.
	 */
	public void setSelectedNonNativeapps(final List<String> selectedNonNativeapps) {
		this.selectedNonNativeapps = selectedNonNativeapps;
	}

	/**
	 * Get the user selected previous analysis result file path.
	 *
	 * @return selectedComparisonInput, return a String value.
	 */
	public String getSelectedComparisonInput() {
		return this.selectedComparisonInput;
	}

	/**
	 * Set the user selected previous analysis result file path.
	 *
	 * @param selectedComparisonInput
	 *            String value which contains the file location path of the
	 *            Previous Analysis.
	 */
	public void setSelectedComparisonInput(final String selectedComparisonInput) {
		this.selectedComparisonInput = selectedComparisonInput;
	}

	/**
	 * Get the instance of the previous analysis result.
	 *
	 * @return previousAnalysisResult, instance of the {@code AnalysisResult}
	 *         class.
	 */
	public AnalysisResult getPreviousAnalysisResult() {
		return this.previousAnalysisResult;
	}

	/**
	 * Set the instance of the previous analysis result.
	 *
	 * @param previousAnalysisResult
	 *            Instance of the AnalysisResult class
	 */
	public void setPreviousAnalysisResult(final AnalysisResult previousAnalysisResult) {
		this.previousAnalysisResult = previousAnalysisResult;
	}

	/**
	 * Get the value of result representation.
	 *
	 * @return resultRepresentation, instance of {@code ResultRepresentation}
	 *         enum.
	 */
	public ResultRepresentation getResultRepresentation() {
		return this.resultRepresentation;
	}

	/**
	 * Set the value of result representation.
	 *
	 * @param resultRepresentation
	 *            Instance of ResultRepresentation enum.
	 */
	/*
	 * public void setResultRepresentation(final ResultRepresentation
	 * resultRepresentation) { this.resultRepresentation = resultRepresentation;
	 * }
	 */

	/**
	 * Get the value of result view set by the user.
	 *
	 * @return resultView, instance of {@code ResultView} enum.
	 */
	public ResultView getResultView() {
		return this.resultView;
	}

	/**
	 * Set the value of result view.
	 *
	 * @param resultView
	 *            Instance of ResultView enum.
	 */
	/*
	 * public void setResultView(final ResultView resultView) { this.resultView
	 * = resultView; }
	 */

	/**
	 * @return the userSelectedFilters
	 */
	public List<String> getUserSelectedFilters() {
		return this.userSelectedFilters;
	}

	/**
	 * @param userSelectedFilters
	 *            the userSelectedFilters to set
	 */
	/*
	 * public void setUserSelectedFilters(final List<String>
	 * userSelectedFilters) { this.userSelectedFilters = userSelectedFilters; }
	 */

	/**
	 * @return the userSelectedDetailLevel
	 */
	public String getUserSelectedDetailLevel() {
		return this.userSelectedDetailLevel;
	}

	/**
	 * @param userSelectedDetailLevel
	 *            the userSelectedDetailLevel to set
	 */
	/*
	 * public void setUserSelectedDetailLevel(final String
	 * userSelectedDetailLevel) { this.userSelectedDetailLevel =
	 * userSelectedDetailLevel; }
	 */

	/**
	 * Method for converting the initial input apk files from String instances
	 * to File instances.
	 *
	 * @return void
	 */
	public void createAPKFilesForInitialInput() {
		this.initialInputAPKFiles = new ArrayList<File>();
		for (final String inputFile : this.selectedInitialInput) {
			final File file = new File(inputFile);
			this.initialInputAPKFiles.add(file);
		}
	}

	/**
	 * Method for converting the non native apk files from String instances to
	 * File instances.
	 *
	 * @return void
	 */
	public void createAPKFilesForNonNativeApps() {
		this.nonNativeAPKFiles = new ArrayList<>();
		if (this.selectedNonNativeapps != null) {
			for (final String inputFile : this.selectedNonNativeapps) {
				final File file = new File(inputFile);
				this.nonNativeAPKFiles.add(file);
			}
		}
	}

	/**
	 * Method for converting the previous analysis result value from String
	 * instance to File instance.
	 *
	 * @return void
	 */
	public void createPreviousAnalysisResultFile() {
		this.previousAnalysisResultFile = new File(this.selectedComparisonInput);
	}

	/**
	 * Get the apk files for analysis.
	 *
	 * @return initialInputAPKFiles, list of File instances.
	 */
	public List<File> getInitialInputAPKFiles() {

		return this.initialInputAPKFiles;
	}

	/**
	 * Get the non native apk files for analysis.
	 *
	 * @return nonNativeAPKFiles, list of File instances.
	 */
	public List<File> getNonNativeAPKFiles() {
		return this.nonNativeAPKFiles;

	}

	/**
	 * Get the previous analysis result as a file.
	 *
	 * @return previousAnalysisResultFile, returns the file instance.
	 */
	public File getPreviousAnalysisResultFile() {
		return this.previousAnalysisResultFile;
	}

	/**
	 * Get the file path for viewing or saving the file
	 *
	 * @return filePath, returns the file path as String.
	 */
	public String getFilePath() {
		return this.filePath;
	}

	/**
	 * Set the file path for viewing or saving the file
	 *
	 * @param filePath
	 */
	/*
	 * public void setFilePath(final String filePath) { this.filePath =
	 * filePath; }
	 */

	/**
	 * Get the terminate variable value
	 *
	 * @return the terminate, boolean value. Default value is true
	 */
	public boolean isTerminate() {
		return this.terminate;
	}

	/**
	 * Set the terminate variable value
	 *
	 * @param terminate
	 *            the terminate to set
	 */
	public void setTerminate(final boolean terminate) {
		this.terminate = terminate;
	}

	/**
	 * @return the testingScenario
	 */
	public boolean isTestingScenario() {
		return this.testingScenario;
	}

	/**
	 * @param testingScenario
	 *            the testingScenario to set
	 */
	/*
	 * public void setTestingScenario(final boolean testingScenario) {
	 * this.testingScenario = testingScenario; }
	 */

	/**
	 * @return the showTestStatistics
	 */
	public boolean isShowTestStatistics() {
		return this.showTestStatistics;
	}

	/**
	 * @param showTestStatistics
	 *            the showTestStatistics to set
	 */
	/*
	 * public void setShowTestStatistics(final boolean showTestStatistics) {
	 * this.showTestStatistics = showTestStatistics; }
	 */

	/**
	 * @return the tsOption
	 */
	public ToolSpecificOption getTsOption() {
		return this.tsOption;
	}

	/**
	 * @param tsOption
	 *            the tsOption to set
	 */
	/*
	 * public void setTsOption(final ToolSpecificOption tsOption) {
	 * this.tsOption = tsOption; }
	 */

}
