package de.upb.pga3.panda2.core;

import java.nio.file.Path;
import java.util.List;

import de.upb.pga3.panda2.core.datastructures.AnalysisResult;

/**
 * Interface for the analysis logic executed by the {@link Analysis}. It
 * contains methods for analyses of type initial and aggregation.
 * 
 * @author Fabian
 *
 */
public interface AnalysisProcedure {

	/**
	 * Method to perform an analysis of type aggregation based on a list of
	 * sub-results.
	 * 
	 * @param subResList
	 *            The list of {@link AnalysisResult}s that should be aggregated.
	 * @param prevRes
	 *            A {@link AnalysisResult} that was previously computed for
	 *            {@code COMPARISON} mode.
	 * @return The computed aggregation result.
	 */
	public AnalysisResult doAggregationAnalysis(List<AnalysisResult> subResList, AnalysisResult prevRes);

	/**
	 * Method to perform an analysis of initial type based on a single apk file.
	 * 
	 * @param apkFile
	 *            The apk file that should be analyzed.
	 * @param prevRes
	 *            A {@link AnalysisResult} that was previously computed for
	 *            {@code COMPARISON} mode.
	 * @return The computed initial result.
	 */
	public AnalysisResult doInitialAnalysis(Path apkFile, AnalysisResult prevRes);

}
