package de.upb.pga3.panda2.core.datastructures;

/**
 * Permission object holds information of permission in android app
 *
 * @author nptsy
 * @author Fabian
 */
public class Permission {
	// name of permission
	private final String mStrName;

	/**
	 * Constructor
	 *
	 * @param inName
	 *            name of permission
	 */
	public Permission(final String inName) {

		if (inName != null) {
			this.mStrName = inName;
		} else {
			throw new IllegalArgumentException("The name of a permission must not be null!");
		}
	}

	/**
	 * get permission name
	 *
	 * @return the string of permission name
	 */
	public String getName() {
		return this.mStrName;
	}

	@Override
	public String toString() {
		return getName();
	}

	@Override
	public int hashCode() {

		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.mStrName == null) ? 0 : this.mStrName.hashCode());
		return result;
	}

	@Override
	public boolean equals(final Object obj) {

		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final Permission other = (Permission) obj;
		if (this.mStrName == null) {
			if (other.mStrName != null) {
				return false;
			}
		} else if (!this.mStrName.equals(other.mStrName)) {
			return false;
		}
		return true;
	}
}
