package de.upb.pga3.panda2.core.datastructures;

import java.util.List;

/**
 * ResultInput class handles the result that load from file
 *
 * @author nptsy
 */
public class ResultInput implements Input {
	// list of analysis result
	private List<AnalysisResult> mLstAnalysisResult;

	/**
	 * Constructor
	 *
	 * @param inLstAnalysisResult
	 *            list of AnalysisResult
	 */
	public ResultInput(final List<AnalysisResult> inLstAnalysisResult) {
		this.mLstAnalysisResult = inLstAnalysisResult;
	}

	/**
	 * get list of AnalysisResult
	 *
	 * @return list of AnalysisResult
	 */
	public List<AnalysisResult> getResults() {
		return this.mLstAnalysisResult;
	}
}
