/**
 *
 */
package de.upb.pga3.panda2.core.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/**
 * ConfigManager for loading all configuration which is defined in file
 * config.properties
 *
 * @author nptsy
 */
public final class ConfigManager {
	private static ConfigManager INSTANCE = new ConfigManager();

	private Properties prop;

	public static ConfigManager getInstance() {
		return INSTANCE;
	}

	/**
	 * Constructor
	 *
	 * load all the content inside file config.properties in folder conf
	 */
	private ConfigManager() {
		// load the config file here

		this.prop = new Properties();

		InputStream input = null;

		try {
			final String configFilePath = System.getProperty("user.dir") + File.separator + "conf/config.properties";
			final File f = new File(configFilePath);
			input = new FileInputStream(f);
			// load a properties file
			this.prop.load(input);

			// get the property value and print it out
			// mLocaleFormat = this.prop.getProperty("locale_currency");

		} catch (final IOException ex) {
			ex.printStackTrace();
		} finally {
			if (input != null) {
				try {
					input.close();
				} catch (final IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * get android jar path
	 *
	 * @return
	 */
	public String getAndroidJarPath() {
		return this.prop.getProperty("android_jar_path");
	}

	/**
	 * get list of excluded packages. The A3 tool won't consider classes in
	 * those excluded packages
	 *
	 * @return list of excluded packages
	 */
	public List<String> getExcludedPackages() {
		final List<String> lstExcludedPacks = new ArrayList<String>();
		final String strExclPackages = this.prop.getProperty("exclude_packages");
		final String[] lstExclPacks = strExclPackages.split(",");
		for (final String exclPack : lstExclPacks) {
			lstExcludedPacks.add(exclPack.trim());
		}
		return lstExcludedPacks;

	}
}
