package de.upb.pga3.panda2.extension;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;

/**
 * Interface for performing an analysis on an {@link AnalysisGraph} to compute
 * an {@link AnalysisResult} out of it. This is the third step of the
 * {@link A3AnalysisProcedure}.
 *
 * @author Fabian
 *
 */
public interface Analyzer {

	/**
	 * Performs the analysis on the given {@link AnalysisGraph}.
	 *
	 * @param ag
	 *            The {@code AnalysisGraph} to perform the analysis on.
	 * @param prevRes
	 *            The previously computed result for {@code COMPARISON} mode.
	 * @return The computed result for the given {@code AnalysisGraph}.
	 */
	public AnalysisResult analyze(AnalysisGraph ag, AnalysisResult prevRes);

}
