package de.upb.pga3.panda2.extension;

import java.nio.file.Path;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.Input;

/**
 * Interface for computing an {@link AnalysisGraph} from an {@link Input} by
 * adding additional edges. This is the second step of the
 * {@link A3AnalysisProcedure}.
 *
 * @author Fabian
 *
 */
public interface GraphGenerator {

	/**
	 * Creates an {@link AnalysisGraph} from the given {@link Input}.
	 * 
	 * @param in
	 *            The {@code Input} to compute the {@code AnalysisGraph} for.
	 * @param apk
	 *            The apk file the {@code Input} is based on for initial
	 *            analyses.
	 * @return The generated {@code AnalysisGraph}.
	 */
	public AnalysisGraph generateGraph(Input in, Path apk);

}
