package de.upb.pga3.panda2.extension.lvl1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import de.upb.pga3.panda2.core.datastructures.Permission;

/**
 * Represent the drawing in the graphical result.
 *
 * @author Felix
 */
public class SVGGraphicLvl1 {
	private List<SVGArrowLvl1> arrows = new ArrayList<>();
	private Map<Permission, SVGPermissionLvl1> mapOfPermissions = new HashMap<>();
	private SVGBarLvl1[] bars = new SVGBarLvl1[5];
	private SVGBarLvl1[] barsComp = new SVGBarLvl1[5];

	private int xLineStart;

	private boolean compare;

	public SVGGraphicLvl1(final List<SVGArrowLvl1> arrows, final Map<Permission, SVGPermissionLvl1> mapOfPermissions,
			final SVGBarLvl1[] bars, final SVGBarLvl1[] barsComp, final int xLineStart, final boolean compare) {
		this.arrows = arrows;
		this.mapOfPermissions = mapOfPermissions;
		this.bars = bars;
		this.barsComp = barsComp;

		this.xLineStart = xLineStart;

		this.compare = compare;
	}

	@Override
	public String toString() {
		final StringBuilder svgBody = new StringBuilder();
		svgBody.append("\n\t<!-- Permissions -->\n");
		for (final SVGPermissionLvl1 svgObject : this.mapOfPermissions.values()) {
			String shortName = svgObject.getPermission().getName();
			if (shortName.length() > 30) {
				shortName = ".." + shortName.substring(shortName.length() - 27);
			}
			svgBody.append("\t<text x=\"" + this.xLineStart + "\" y=\"" + svgObject.getY()
					+ "\" fill=\"black\" style=\"font-family: Verdana; font-size: 13px;\">" + shortName + "<title>"
					+ svgObject.getPermission().getName() + "</title></text>\n");
		}
		svgBody.append("\n\t<!-- Groups -->\n");
		for (int i = 0; i < 5; i++) {
			svgBody.append("\t<rect x=\"" + this.bars[i].getX() + "\" y=\"" + this.bars[i].getY() + "\" width=\""
					+ AnalysisResultLvl1.barWidth + "\" height=\"" + this.bars[i].getHeight() + "\" fill=\""
					+ ResultTypeLvl1.getColorOfType(i)
					+ "\" style=\"stroke-width: 1px; vector-effect: non-scaling-stroke;\" stroke=\"#000000\"><title>"
					+ ResultTypeLvl1.getStringOfType(i) + "</title></rect>\n");
		}
		if (this.compare) {
			for (int i = 0; i < 5; i++) {
				svgBody.append("\t<rect x=\"" + this.barsComp[i].getX() + "\" y=\"" + this.barsComp[i].getY()
						+ "\" width=\"" + AnalysisResultLvl1.barWidth + "\" height=\"" + this.barsComp[i].getHeight()
						+ "\" fill=\"" + ResultTypeLvl1.getColorOfType(i)
						+ "\" style=\"stroke-width: 1px; vector-effect: non-scaling-stroke;\" stroke=\"#000000\"><title>"
						+ ResultTypeLvl1.getStringOfType(i) + "</title></rect>\n");
			}
		}
		svgBody.append("\n\t<!-- Arrows -->\n");
		for (final SVGArrowLvl1 svgObject : this.arrows) {
			svgBody.append("\t<line x1=\"" + svgObject.getFrom()[0] + "\" y1=\"" + svgObject.getFrom()[1] + "\" x2=\""
					+ svgObject.getTo()[0] + "\" y2=\"" + svgObject.getTo()[1]
					+ "\" stroke=\"black\" style=\"stroke-width: 1px; vector-effect: non-scaling-stroke; fill: none;\" />\n");
		}

		return svgBody.toString();
	}
}
