/**
 *
 */
package de.upb.pga3.panda2.extension.lvl2a.analyzer;

import java.util.Set;

import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisResultLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.ComparisonAnalysisResultLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.FlowPath;

/**
 * ResultComparerLvl2a class
 *
 * @author nptsy
 * @author Fabian
 */
public class ResultComparerLvl2a {

	/**
	 * compare analysis result of current and previous result
	 *
	 * @param inPrevResult
	 * @param inCurrentResult
	 * @return
	 */
	public ComparisonAnalysisResultLvl2a comparePrevAndCur(final AnalysisResultLvl2a inPrevResult,
			final AnalysisResultLvl2a inCurrentResult) {

		final ComparisonAnalysisResultLvl2a compRes = new ComparisonAnalysisResultLvl2a(inCurrentResult);
		compRes.initialize(CoreServices.getXMLParserInstance());

		final Set<FlowPath> prevPaths = inPrevResult.getPaths();
		final Set<FlowPath> currPaths = compRes.getPaths();

		// Find removed paths
		for (final FlowPath fp : prevPaths) {
			if (!currPaths.contains(fp)) {
				compRes.addRemovedPath(fp);
			}
		}

		// Find new paths
		for (final FlowPath fp : currPaths) {
			if (!prevPaths.contains(fp)) {
				compRes.addNewPath(fp);
			}
		}

		return compRes;
	}
}
