/**
 *
 */
package de.upb.pga3.panda2.extension.lvl2a.analyzer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.utilities.Constants;
import soot.Body;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.jimple.internal.JInvokeStmt;

/**
 * SourceAndSinkComputer class for computing sources and sinks on graph
 *
 * @author nptsy
 * @author monika
 */
public class SourceAndSinkComputer {
	/**
	 * Constructor
	 */
	public SourceAndSinkComputer() {

	}

	/**
	 * compute list of sources
	 *
	 * @param inArrStm
	 *            list of statements
	 * @return list of sources associated with permissions
	 */
	public Map<Permission, List<Unit>> computeSources(final List<Unit> inLstStm, final EnhancedInput inp) {
		if (inLstStm != null && !inLstStm.isEmpty()) {
			final Map<Permission, List<Unit>> mapOfSources = new HashMap<>();

			for (final Unit unit : inLstStm) {
				// get unit as a statement
				final Stmt stmt = (Stmt) unit;

				// process unit which is an invoked statement
				if (stmt instanceof JInvokeStmt && stmt.containsInvokeExpr()) {
					final JInvokeStmt invokeStmt = (JInvokeStmt) unit;
					// get invoke expression
					final InvokeExpr invExp = invokeStmt.getInvokeExpr();
					if (invExp != null && invExp.getMethod() != null) {

						// get signature
						final String signature = invExp.getMethod().getSignature();

						/*
						 * -----------------------------------------------------
						 * process for the second type of source
						 */
						if (signature.contains(Constants.METHOD_SET_RESULT1)
								|| signature.contains(Constants.METHOD_SET_RESULT2)) {

							final Body body = inp.getBodyForUnit(unit);
							if (body != null) {
								final SootMethod smethod = body.getMethod();
								final SootClass sclass = smethod.getDeclaringClass();

								if (inp.isAndroidComponent(sclass)) {
									final Collection<Permission> colPerms = inp.getPermissionsFor(sclass);
									if (colPerms != null) {
										for (final Permission perm : colPerms) {
											List<Unit> lstUnits = mapOfSources.get(perm);
											if (lstUnits == null) {
												lstUnits = new ArrayList<>();
												lstUnits.add(unit);
												mapOfSources.put(perm, lstUnits);
											} else {
												lstUnits.add(unit);
											}
										}
									}
								}
							}
							continue;
						}

						/*
						 * -----------------------------------------------------
						 */

						// get class name
						final String className = invExp.getMethod().getDeclaringClass().getName();

						/*
						 * compare signature here with the list of sources get
						 * from DataStorage
						 */
						final boolean isSource = CoreServices.getDataStorageInstance().isSource(className, signature);
						if (isSource) {
							for (final Permission permission : inp.getPermissionsFor(unit)) {
								List<Unit> lstUnits = mapOfSources.get(permission);
								if (lstUnits == null) {
									lstUnits = new ArrayList<>();
									lstUnits.add(unit);
									mapOfSources.put(permission, lstUnits);
								} else {
									lstUnits.add(unit);
								}
							}
						}
					}
				}
				/*
				 * otherwise process unit which is an expression. Here we just
				 * consider expression on the right hand side of unit
				 */
				else {
					final List<ValueBox> valueBoxes = stmt.getUseBoxes();
					if (valueBoxes != null && !valueBoxes.isEmpty()) {
						for (final ValueBox valueBox : valueBoxes) {
							final Value value = valueBox.getValue();
							if (value instanceof AbstractInvokeExpr) {
								final AbstractInvokeExpr expr = (AbstractInvokeExpr) value;
								if (expr.getMethod() != null) {
									// get signature
									final String signature = expr.getMethod().getSignature();

									// get class name
									final String className = expr.getMethod().getDeclaringClass().getName();

									/*
									 * compare signature here with the list of
									 * sources get from DataStorage
									 */
									final boolean isSource = CoreServices.getDataStorageInstance().isSource(className,
											signature);
									if (isSource) {
										for (final Permission permission : inp.getPermissionsFor(unit)) {
											List<Unit> lstUnits = mapOfSources.get(permission);
											if (lstUnits == null) {
												lstUnits = new ArrayList<>();
												lstUnits.add(unit);
												mapOfSources.put(permission, lstUnits);
											} else {
												lstUnits.add(unit);
											}

										}
									}
								}
							}
						}
					}
				}
			}
			return mapOfSources;

		}
		return null;
	}

	/**
	 * compute list of sinks
	 *
	 * @param inArrStm
	 *            list of statements
	 * @return a map of sinks associated with permissions
	 */
	public Map<Permission, List<Unit>> computeSinks(final List<Unit> inLstStm, final EnhancedInput inp) {

		if (inLstStm != null && !inLstStm.isEmpty()) {
			final Map<Permission, List<Unit>> mapOfSinks = new HashMap<>();

			for (final Unit unit : inLstStm) {

				final Stmt stmnt = (Stmt) unit;
				// process unit as an invoked statement
				if (stmnt instanceof JInvokeStmt && stmnt.containsInvokeExpr()) {
					final JInvokeStmt invokeStmt = (JInvokeStmt) unit;
					final InvokeExpr invExp = invokeStmt.getInvokeExpr();
					if (invExp != null && invExp.getMethod() != null) {

						// get signature
						final String signature = invExp.getMethod().getSignature();

						// get class name
						final String className = invExp.getMethod().getDeclaringClass().getName();

						/*
						 * compare signature here with the list of sources get
						 * from DataStorage
						 */
						final boolean isSink = CoreServices.getDataStorageInstance().isSink(className, signature);

						if (isSink) {
							for (final Permission permission : inp.getPermissionsFor(unit)) {
								List<Unit> lstUnits = mapOfSinks.get(permission);
								if (lstUnits == null) {
									lstUnits = new ArrayList<>();
									lstUnits.add(unit);
									mapOfSinks.put(permission, lstUnits);
								} else {
									lstUnits.add(unit);
								}
							}
						}
					}
				}
				/*
				 * otherwise process unit as an expression. Here we just
				 * consider expression on the right hand side of unit
				 */
				else {
					final List<ValueBox> valueBoxes = stmnt.getUseBoxes();
					if (valueBoxes != null && !valueBoxes.isEmpty()) {
						for (final ValueBox valueBox : valueBoxes) {
							final Value value = valueBox.getValue();
							if (value instanceof AbstractInvokeExpr) {
								final AbstractInvokeExpr expr = (AbstractInvokeExpr) value;
								if (expr.getMethod() != null) {
									// get signature
									final String signature = expr.getMethod().getSignature();

									// get class name
									final String className = expr.getMethod().getDeclaringClass().getName();

									/*
									 * compare signature here with the list of
									 * sources get from DataStorage
									 */
									final boolean isSink = CoreServices.getDataStorageInstance().isSink(className,
											signature);
									if (isSink) {
										for (final Permission permission : inp.getPermissionsFor(unit)) {
											List<Unit> lstUnits = mapOfSinks.get(permission);
											if (lstUnits == null) {
												lstUnits = new ArrayList<>();
												lstUnits.add(unit);
												mapOfSinks.put(permission, lstUnits);
											} else {
												lstUnits.add(unit);
											}
										}
									}
								}
							}
						}
					}
				}
			}

			return mapOfSinks;
		}

		return null;
	}
}
