package de.upb.pga3.panda2.extension.lvl2a.flowpath;

import java.util.HashMap;
import java.util.Map;

import de.upb.pga3.panda2.core.datastructures.Permission;

public final class ResourceElement implements PathElement {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 6022575591958902880L;

	private static final Map<ResourceElement, ResourceElement> instancePool = new HashMap<>();

	private final String permName;

	public static ResourceElement get(final Permission permName) {

		ResourceElement resEle = new ResourceElement(permName);
		if (instancePool.containsKey(resEle)) {
			resEle = instancePool.get(resEle);
		} else {
			instancePool.put(resEle, resEle);
		}
		return resEle;
	}

	private ResourceElement(final Permission perm) {

		if (perm == null) {
			throw new IllegalArgumentException("The given permission must not be null!");
		}

		this.permName = perm.getName();
	}

	public String getPermissionName() {
		return toString();
	}

	@Override
	public String toFullString() {
		return toString();
	}

	@Override
	public String toString() {
		return this.permName;
	}

	@Override
	public int hashCode() {

		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.permName == null) ? 0 : this.permName.hashCode());
		return result;
	}

	@Override
	public boolean equals(final Object obj) {

		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final ResourceElement other = (ResourceElement) obj;
		if (this.permName == null) {
			if (other.permName != null) {
				return false;
			}
		} else if (!this.permName.equals(other.permName)) {
			return false;
		}
		return true;
	}

}
