/**
 *
 */
package de.upb.pga3.panda2.extension.lvl2a.graphgenerator;

import java.util.Collection;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.services.IntentInformation;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisGraphLvl2a;

/**
 * IntentAnalyzerLvl2a
 *
 * @author nptsy
 * @author wedelm
 * @author Fabian
 */
public class IntentAnalyzerLvl2a {

	private NodeLinkerLvl2a nodeLinker;

	/**
	 * Constructor
	 */
	public IntentAnalyzerLvl2a(final NodeLinkerLvl2a nodeLinker) {
		this.nodeLinker = nodeLinker;
	}

	/**
	 * analyze explicit intents
	 *
	 * @param inGraph
	 *            analysis graph of lvl 2a
	 * @return AnalysisGraphLvl2a object with explicit intents
	 */
	public AnalysisGraphLvl2a analyzeExplicitIntents(final AnalysisGraphLvl2a inGraph) {

		final EnhancedInput eInput = (EnhancedInput) inGraph.getInput();

		for (final Collection<IntentInformation> intentInfoCollection : eInput.getIntents().values()) {
			for (final IntentInformation intentInfo : intentInfoCollection) {
				if (intentInfo.getTypeIntent() == IntentInformation.TYPE_EXPLICIT) {
					this.nodeLinker.addTransitionsForExplicitIntent(intentInfo);
				}
			}
		}
		return inGraph;

	}

	/**
	 * analyze the implicit intents if any available
	 *
	 * @param inGraph
	 *            analysis graph of lvl 2a
	 * @return AnalysisGraphLvl2a object with iplicit intents
	 */
	public AnalysisGraphLvl2a analyzeImplicitIntents(final AnalysisGraphLvl2a inGraph) {
		final EnhancedInput eInput = (EnhancedInput) inGraph.getInput();

		for (final Collection<IntentInformation> intentInfoCollection : eInput.getIntents().values()) {
			for (final IntentInformation intentInfo : intentInfoCollection) {
				if (intentInfo.getTypeIntent() == IntentInformation.TYPE_IMPLICIT) {
					this.nodeLinker.addTransitionsForImplicitIntent(intentInfo);
				}
			}
		}

		return inGraph;
	}

}
