package de.upb.pga3.panda2.extension.lvl2b;

import de.upb.pga3.panda2.core.datastructures.Permission;

/**
 * In order to differentiate between direct and indirect access to the
 * permission we need to store that extra information along with the permission
 * in objects of this class.
 *
 * @author Felix
 *
 */
public class ResultItemLvl2b {
	public static final int DIRECT = 0;
	public static final int INDIRECT = 1;
	public static final int BOTH = 2;

	private Permission permission;
	private int direct;

	public ResultItemLvl2b(final Permission permission, final int direct) {
		this.permission = permission;
		this.direct = direct;
	}

	public Permission getPermission() {
		return this.permission;
	}

	public int getDirect() {
		return this.direct;
	}

	/**
	 * Replies the readable version of the extra information about the direct or
	 * indirect access.
	 *
	 * @return The string representation of the extra information about the
	 *         direct or indirect access.
	 */
	public String getDirectString() {
		if (this.direct == BOTH) {
			return " (direct and indirect)";
		} else if (this.direct == INDIRECT) {
			return " (indirect)";
		} else {
			return "";
		}
	}
}
