package de.upb.pga3.panda2.extension.lvl2b.graphgenerator;

import java.nio.file.Path;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.Input;
import de.upb.pga3.panda2.core.datastructures.ResultInput;
import de.upb.pga3.panda2.extension.GraphGenerator;

/**
 * This is the specific GraphGenerator for Level 2b.
 *
 * @author Felix
 */
public class GraphGeneratorLvl2b implements GraphGenerator {
	// Logger initialization
	private static final Logger LOGGER = LogManager.getLogger(GraphGeneratorLvl2b.class);

	@Override
	public AnalysisGraph generateGraph(final Input in, final Path apk) {
		LOGGER.info("GraphGenerator started (Permission usage - Inter App - Level 2b).");

		final IntentAnalyzerLvl2b intentAnalyzer = new IntentAnalyzerLvl2b((ResultInput) in);
		intentAnalyzer.analyzeIntents();

		LOGGER.info("GraphGenerator finished (Permission usage - Inter App - Level 2b).");
		return intentAnalyzer.getGraph();
	}

}
