package de.upb.pga3.panda2.extension.lvl2b.graphgenerator;

import java.util.Collection;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.ResultInput;
import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.core.services.IntentInformation;
import de.upb.pga3.panda2.core.services.StatementAnalyzer;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;

/**
 * This class is using the {@link StatementAnalyzer} in order to link the
 * {@link EnhancedInput} accordingly.
 *
 * @author Felix
 */
public class IntentAnalyzerLvl2b {
	private static final Logger LOGGER = LogManager.getLogger(IntentAnalyzerLvl2b.class);

	private ResultInput ri;
	private NodeLinkerLvl2b nodeLinker;

	/**
	 * Constructor is initializing the Nodelinker
	 *
	 * @param ri
	 *            ResultInput object generated so far
	 */
	public IntentAnalyzerLvl2b(final ResultInput ri) {
		this.ri = ri;
		this.nodeLinker = new NodeLinkerLvl2b(new AnalysisGraph(ri));
	}

	/**
	 * Iterates over all {@link Element}s and calls the {@link NodeLinkerLvl2b}
	 * in case of an valid intent definition.
	 */
	public void analyzeIntents() {
		EnhancedInput ei = null;
		for (int i = 0; i < this.ri.getResults().size(); i++) {
			ei = (EnhancedInput) ((AnalysisResultLvl1) this.ri.getResults().get(i)).getAnalysisGraph().getInput();

			for (final Collection<IntentInformation> intentInfoCollection : ei.getIntents().values()) {
				for (final IntentInformation intentInfo : intentInfoCollection) {
					if (intentInfo.getTypeIntent() == IntentInformation.TYPE_IMPLICIT) {
						for (int j = 0; j < this.ri.getResults().size(); j++) {
							final EnhancedInput tempEi = (EnhancedInput) ((AnalysisResultLvl1) this.ri.getResults()
									.get(j)).getAnalysisGraph().getInput();
							if (ei != tempEi) {
								intentInfo.addTargetClasses(CoreServices.getStatementAnalyzerInstance()
										.getTargetsByActionString(intentInfo.getClassNameOrActionString(), tempEi));
							}
						}
						this.nodeLinker.link(intentInfo);
					}
				}
			}
		}
	}

	public AnalysisGraph getGraph() {
		return this.nodeLinker.getGraph();
	}
}
