package de.upb.pga3.panda2.utilities;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import de.upb.pga3.panda2.core.datastructures.AnalysisResult;

/**
 * This class is used for serializing and de-serializing the instance of the
 * AnalysisResult class using normal Java Serialzation.
 *
 * @author Sriram
 *
 */
@SuppressWarnings("unused")
public class DefaultJavaSerializer {

	private static final Logger logger = LogManager.getLogger(DefaultJavaSerializer.class);

	/**
	 * Default Constructor
	 */
	public DefaultJavaSerializer() {
	}

	/**
	 * Method for saving the object in the file.
	 *
	 * @param path
	 * @param anaResult
	 * @throws IOException
	 */
	public static void writeObject(final String path, final AnalysisResult anaResult) throws IOException {
		final FileOutputStream fout = new FileOutputStream(path);
		final ObjectOutputStream oos = new ObjectOutputStream(fout);
		oos.writeObject(anaResult);
		oos.close();
		fout.close();
	}

	/**
	 * Method for reading the contents from the file and creating the object out
	 * of it.
	 *
	 * @param resultPath
	 * @return analysisResult object
	 * @throws IOException
	 * @throws ClassNotFoundException
	 */
	public static AnalysisResult readObject(final String resultPath) throws IOException, ClassNotFoundException {
		final FileInputStream fileIn = new FileInputStream(resultPath);
		final ObjectInputStream in = new ObjectInputStream(fileIn);
		final AnalysisResult analysisResult = (AnalysisResult) in.readObject();
		in.close();
		fileIn.close();
		return analysisResult;
	}
}
