package de.upb.pga3.panda2.utilities;

import java.time.Duration;
import java.time.LocalDateTime;

/**
 *
 * @author Fabian
 *
 */
public class StopWatch {

	private boolean started;
	private boolean stopped;

	private LocalDateTime startTime;
	private LocalDateTime stopTime;

	public StopWatch() {
		this.started = false;
		this.stopped = false;
	}

	public synchronized void start() {

		if (!this.started) {
			this.startTime = LocalDateTime.now();
			this.started = true;
			this.stopped = false;
		} else {
			throw new IllegalStateException("Stopwatch has alredy been started!");
		}
	}

	public synchronized void stop() {

		if (this.started && !this.stopped) {
			this.stopTime = LocalDateTime.now();
			this.stopped = true;
			this.started = false;
		} else if (!this.started) {
			throw new IllegalStateException("Stopwatch has not been started!");
		} else {
			throw new IllegalStateException("Stopwatch has alredy been stopped!");
		}
	}

	public Duration getTimeTaken() {

		if (this.stopped) {
			return Duration.between(this.startTime, this.stopTime);
		} else {
			throw new IllegalStateException("Stopwatch has not been stopped!");
		}
	}

}
