package de.upb.pga3.panda2.test.client.core;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.ArrayList;
import java.util.List;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import de.upb.pga3.panda2.client.core.AnalysisRegistry;
import de.upb.pga3.panda2.client.core.ConfigManager;
import de.upb.pga3.panda2.client.core.UserInput;
import de.upb.pga3.panda2.client.core.datastructures.LevelSpecificMode;
import de.upb.pga3.panda2.client.core.datastructures.Mode;
import de.upb.pga3.panda2.client.core.datastructures.UIMessage;
import de.upb.pga3.panda2.client.core.datastructures.UIMessageType;

/**
 * Test cases for ConfigManager class.
 *
 * @author Sriram
 *
 */
public class ConfigManagerTest {

	UserInput ui, uiempty, ui1;
	List<String> initialAPKInput;
	List<String> nonNativeAPKInput;

	@Rule
	public final ExpectedException exception = ExpectedException.none();

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
		final ConfigManager configManager = new ConfigManager();
		this.uiempty = new UserInput();
		this.ui = new UserInput(AnalysisRegistry.LEVEL1, null, Mode.SUMMARY);
		this.ui1 = new UserInput(AnalysisRegistry.LEVEL2B, LevelSpecificMode.ALL, Mode.COMPARISON);
		this.initialAPKInput = new ArrayList<String>();
		this.nonNativeAPKInput = new ArrayList<String>();
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void validateInputtest() {

		final UIMessage uiMessage = ConfigManager.validateInput(this.ui);
		assertNotNull(uiMessage);
	}

	@Test
	public void validateInputNegativetest() {

		final UIMessage uiMessage = ConfigManager.validateInput(this.uiempty);
		assertEquals(UIMessageType.ERROR, uiMessage.getType());
	}

	@Test
	public void validateInputNegative1test() {

		final UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
		assertEquals(UIMessageType.ERROR, uiMessage.getType());
	}

	@Test
	public void validateInputNegative2test() {

		final UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
		assertEquals(UIMessageType.ERROR, uiMessage.getType());
	}

	@Test
	public void validateInputNegative3test() {
		this.initialAPKInput.add("");
		this.ui.setSelectedInitialInput(this.initialAPKInput);
		this.ui.createAPKFilesForInitialInput();
		final UIMessage uiMessage = ConfigManager.validateInput(this.ui);
		assertEquals(UIMessageType.ERROR, uiMessage.getType());
	}

	@Test
	public void validateInputNegative4test() {
		this.ui1 = new UserInput(AnalysisRegistry.LEVEL2B, LevelSpecificMode.ALL, Mode.COMPARISON);
		final UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
		assertEquals(UIMessageType.ERROR, uiMessage.getType());
	}

	@Test
	public void validateInputNegative5test() {
		this.ui1 = new UserInput(AnalysisRegistry.LEVEL2B, null, Mode.COMPARISON);
		this.initialAPKInput.add("");
		this.ui1.setSelectedInitialInput(this.initialAPKInput);
		this.ui1.createAPKFilesForInitialInput();
		final UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
		assertEquals(UIMessageType.ERROR, uiMessage.getType());
	}

	@Test
	public void validateInputNegative6test() {
		this.ui1 = new UserInput(AnalysisRegistry.LEVEL2B, LevelSpecificMode.ALL, Mode.COMPARISON);
		this.initialAPKInput.add("");
		this.ui1.setSelectedInitialInput(this.initialAPKInput);
		this.ui1.createAPKFilesForInitialInput();
		final UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
		assertEquals(UIMessageType.ERROR, uiMessage.getType());
	}

	@Test
	public void validateInputNegative7test() {
		this.ui1 = new UserInput(AnalysisRegistry.LEVEL2B, LevelSpecificMode.ALL, Mode.COMPARISON);
		this.ui1.setSelectedComparisonInput("");
		this.initialAPKInput.add("test_resources/DummyAPP.apk");
		this.nonNativeAPKInput.add("");
		this.ui1.setSelectedInitialInput(this.initialAPKInput);
		this.ui1.setSelectedNonNativeapps(this.nonNativeAPKInput);
		this.ui1.createAPKFilesForInitialInput();
		this.ui1.createAPKFilesForNonNativeApps();
		this.ui1.createPreviousAnalysisResultFile();
		final UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
		assertEquals(UIMessageType.ERROR, uiMessage.getType());
	}

	@Test
	public void validateInputNegative8test() {
		this.ui1 = new UserInput(AnalysisRegistry.LEVEL2B, LevelSpecificMode.ALL, Mode.COMPARISON);
		this.ui1.setSelectedComparisonInput("");
		this.initialAPKInput.add("test_resources/AllCasesLevel2bAppPart1.apk");
		this.nonNativeAPKInput.add("test_resources/AllCasesLevel2bAppPart2.apk");
		this.ui1.setSelectedInitialInput(this.initialAPKInput);
		this.ui1.setSelectedNonNativeapps(this.nonNativeAPKInput);
		this.ui1.createAPKFilesForInitialInput();
		this.ui1.createAPKFilesForNonNativeApps();
		this.ui1.createPreviousAnalysisResultFile();
		final UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
		assertEquals(UIMessageType.ERROR, uiMessage.getType());
	}

	@Test
	public void validatePositive2Btest() {
		this.ui1 = new UserInput(AnalysisRegistry.LEVEL2B, LevelSpecificMode.ALL, Mode.COMPARISON);
		this.initialAPKInput.add("test_resources/AllCasesLevel2bAppPart1.apk");
		this.nonNativeAPKInput.add("test_resources/AllCasesLevel2bAppPart2.apk");
		this.ui1.setSelectedInitialInput(this.initialAPKInput);
		this.ui1.setSelectedNonNativeapps(this.nonNativeAPKInput);
		this.ui1.setSelectedComparisonInput("test_resources/SimpleMissingInternetP.pa2");
		this.ui1.createAPKFilesForInitialInput();
		this.ui1.createAPKFilesForNonNativeApps();
		this.ui1.createPreviousAnalysisResultFile();
		final UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
		assertEquals(UIMessageType.INFO, uiMessage.getType());
	}
}
