package de.upb.pga3.panda2.test.extension.lvl2a;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisResultLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.analyzer.AnalyzerLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.analyzer.SourceAndSinkComputer;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.FlowPath;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.ResourceElement;
import soot.Unit;

/**
 * The class <code>AnalysisResultLvl2aTest</code> contains tests for the class
 * <code>{@link AnalysisResultLvl2a}</code>.
 *
 * @generatedBy CodePro at 23.02.16 17:01
 * @author Monika
 * @version $Revision: 1.0 $
 */
public class AnalysisResultLvl2aTest {

	private AnalysisGraph inGraph = TestCodeFactory.createAnalysisGraph("test_resources/ExpoAppLvl2a.apk");
	private AnalysisResultLvl2a result = (AnalysisResultLvl2a) new AnalyzerLvl2a().analyze(this.inGraph, null);

	/**
	 * Run the AnalysisResultLvl2a(AnalysisGraph) constructor test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testAnalysisResultLvl2a_1() throws Exception {

		final AnalysisResultLvl2a result1 = new AnalysisResultLvl2a();

		assertNotNull(result1);
	}

	/**
	 * Run the boolean addPath(FlowPath) method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testAddPath_1() throws Exception {
		final AnalysisResultLvl2a fixture = this.result;

		// add existing path again to result
		final FlowPath inPath = fixture.getPaths().iterator().next();

		final boolean result1 = fixture.addPath(inPath);
		assertTrue(result1);
	}

	/**
	 * Run the boolean addPath(FlowPath) method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testAddPath_2() throws Exception {
		final AnalysisResultLvl2a fixture = this.result;
		final FlowPath inPath = null;

		final boolean result1 = fixture.addPath(inPath);

		// add additional test code here
		assertTrue(result1);
	}

	/**
	 * Run the void addSinksMap(Map<Permission,List<Unit>>) method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testAddSinks() throws Exception {
		final SourceAndSinkComputer susi = new SourceAndSinkComputer();
		final Object[] lstNode = this.inGraph.getNodes().toArray();
		final List<Unit> lstNodeUnit = new ArrayList<>();
		if (lstNode != null && lstNode.length > 0) {
			for (final Object obj : lstNode) {
				if (obj instanceof Unit) {
					lstNodeUnit.add((Unit) obj);
				}
			}
		}
		final Map<Permission, List<Unit>> inSinksMap = susi.computeSinks(lstNodeUnit,
				(EnhancedInput) this.inGraph.getInput());
		final AnalysisResultLvl2a fixture = new AnalysisResultLvl2a();

		fixture.addSinks(inSinksMap.keySet().stream().map(p -> ResourceElement.get(p)).collect(Collectors.toList()));
	}

	/**
	 * Run the void addSourcesMap(Map<Permission,List<Unit>>) method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testAddSources() throws Exception {
		final SourceAndSinkComputer susi = new SourceAndSinkComputer();
		final Object[] lstNode = this.inGraph.getNodes().toArray();
		final List<Unit> lstNodeUnit = new ArrayList<>();
		if (lstNode != null && lstNode.length > 0) {
			for (final Object obj : lstNode) {
				if (obj instanceof Unit) {
					lstNodeUnit.add((Unit) obj);
				}
			}
		}
		final AnalysisResultLvl2a fixture = new AnalysisResultLvl2a();
		final Map<Permission, List<Unit>> inSourcesMap = susi.computeSources(lstNodeUnit,
				(EnhancedInput) this.inGraph.getInput());

		fixture.addSources(
				inSourcesMap.keySet().stream().map(p -> ResourceElement.get(p)).collect(Collectors.toList()));
	}

	/**
	 * Run the void createFilters() method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testCreateFilters() throws Exception {
		final AnalysisResultLvl2a fixture = (AnalysisResultLvl2a) new AnalyzerLvl2a().analyze(this.inGraph, null);

		fixture.createFilters();

		// add additional test code here
	}

	/**
	 * Run the List<DetailLevel> getDetailLevels() method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testGetDetailLevels_1() throws Exception {
		final AnalysisResultLvl2a fixture = (AnalysisResultLvl2a) new AnalyzerLvl2a().analyze(this.inGraph, null);

		final List<DetailLevel> result1 = fixture.getDetailLevels();

		assertNotNull(result1);
		assertEquals(4, result1.size());
	}

	/**
	 * Run the List<String> getFilters() method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testGetFilters() throws Exception {
		final AnalysisResultLvl2a fixture = (AnalysisResultLvl2a) new AnalyzerLvl2a().analyze(this.inGraph, null);

		final List<String> result1 = fixture.getFilters();

		assertNotNull(result1);
	}

	/**
	 * Run the String getGraphicalResult(DetailLevel,List<String>,boolean)
	 * method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testGetGraphicalResult() throws Exception {
		final AnalysisResultLvl2a fixture = (AnalysisResultLvl2a) new AnalyzerLvl2a().analyze(this.inGraph, null);
		final DetailLevel inDetailLvl = fixture.getDetailLevels().get(0);
		final List<String> inFilters = fixture.getFilters();
		final boolean inShowStats = true;

		final String result1 = fixture.getGraphicalResult(inDetailLvl, inFilters, inShowStats);
		assertNotNull(result1);
	}

	/**
	 * Run the Set<FlowPath> getPaths() method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testGetPaths() throws Exception {
		final AnalysisResultLvl2a fixture = (AnalysisResultLvl2a) new AnalyzerLvl2a().analyze(this.inGraph, null);

		final Set<FlowPath> result1 = fixture.getPaths();

		assertNotNull(result1);
	}

	/**
	 * Run the String getTextualResult(DetailLevel,List<String>,boolean) method
	 * test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testGetTextualResult_Statement() throws Exception {
		final AnalysisResultLvl2a fixture = (AnalysisResultLvl2a) new AnalyzerLvl2a().analyze(this.inGraph, null);
		final DetailLevel inDetailLvl = fixture.getDetailLevels().get(3);
		final List<String> inFilters = fixture.getFilters();
		final boolean inShowStats = true;

		final String result1 = fixture.getTextualResult(inDetailLvl, inFilters, inShowStats);
		assertNotNull(result1);
	}

	@Test
	public void testGetTextualResult_Method() throws Exception {
		final AnalysisResultLvl2a fixture = (AnalysisResultLvl2a) new AnalyzerLvl2a().analyze(this.inGraph, null);
		final DetailLevel inDetailLvl = fixture.getDetailLevels().get(2);
		final List<String> inFilters = fixture.getFilters();
		final boolean inShowStats = true;

		final String result1 = fixture.getTextualResult(inDetailLvl, inFilters, inShowStats);
		assertNotNull(result1);
	}

	/**
	 * Run the String getTextualResult(DetailLevel,List<String>,boolean) method
	 * test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 29.02.16 17:01
	 */
	@Test
	public void testGetTextualResult_Resource() throws Exception {
		final AnalysisResultLvl2a fixture = (AnalysisResultLvl2a) new AnalyzerLvl2a().analyze(this.inGraph, null);
		final DetailLevel inDetailLvl = fixture.getDetailLevels().get(0);
		final List<String> inFilters = fixture.getFilters();
		final boolean inShowStats = true;

		final String result1 = fixture.getTextualResult(inDetailLvl, inFilters, inShowStats);
		assertNotNull(result1);
	}

	/**
	 * Run the String getTextualResult(DetailLevel,List<String>,boolean) method
	 * test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 29.02.16 17:01
	 */
	@Test
	public void testGetTextualResult_Component() throws Exception {
		final AnalysisResultLvl2a fixture = (AnalysisResultLvl2a) new AnalyzerLvl2a().analyze(this.inGraph, null);
		final DetailLevel inDetailLvl = fixture.getDetailLevels().get(1);
		final List<String> inFilters = fixture.getFilters();
		final boolean inShowStats = true;

		final String result1 = fixture.getTextualResult(inDetailLvl, inFilters, inShowStats);
		assertNotNull(result1);
	}

	@Test
	public void testGetPathsForSink() {
		final AnalysisResultLvl2a fixture = (AnalysisResultLvl2a) new AnalyzerLvl2a().analyze(this.inGraph, null);

		final SourceAndSinkComputer susi = new SourceAndSinkComputer();
		final Object[] lstNode = this.inGraph.getNodes().toArray();
		final List<Unit> lstNodeUnit = new ArrayList<>();
		if (lstNode != null && lstNode.length > 0) {
			for (final Object obj : lstNode) {
				if (obj instanceof Unit) {
					lstNodeUnit.add((Unit) obj);
				}
			}
		}
		final Map<Permission, List<Unit>> inSinksMap = susi.computeSinks(lstNodeUnit,
				(EnhancedInput) this.inGraph.getInput());

		if (inSinksMap != null && !inSinksMap.isEmpty()) {
			final Set<Permission> setPermss = inSinksMap.keySet();
			for (final Permission perm : setPermss) {
				final List<FlowPath> lstFlows = fixture.getPathsForSink(ResourceElement.get(perm));
				assertTrue(lstFlows == null || lstFlows.size() > 0);
			}
		}
	}

	@Test
	public void testGetPathsForSource() {
		final AnalysisResultLvl2a fixture = (AnalysisResultLvl2a) new AnalyzerLvl2a().analyze(this.inGraph, null);

		final SourceAndSinkComputer susi = new SourceAndSinkComputer();
		final Object[] lstNode = this.inGraph.getNodes().toArray();
		final List<Unit> lstNodeUnit = new ArrayList<>();
		if (lstNode != null && lstNode.length > 0) {
			for (final Object obj : lstNode) {
				if (obj instanceof Unit) {
					lstNodeUnit.add((Unit) obj);
				}
			}
		}
		final Map<Permission, List<Unit>> inSourcesMap = susi.computeSources(lstNodeUnit,
				(EnhancedInput) this.inGraph.getInput());

		if (inSourcesMap != null && !inSourcesMap.isEmpty()) {
			final Set<Permission> setPermss = inSourcesMap.keySet();
			for (final Permission perm : setPermss) {
				final List<FlowPath> lstFlows = fixture.getPathsForSource(ResourceElement.get(perm));
				assertTrue(lstFlows == null || lstFlows.size() > 0);
			}
		}

	}

	/**
	 * Perform pre-test initialization.
	 *
	 * @throws Exception
	 *             if the initialization fails for some reason
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Before
	public void setUp() throws Exception {
		// Do nothing
	}

	/**
	 * Perform post-test clean-up.
	 *
	 * @throws Exception
	 *             if the clean-up fails for some reason
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@After
	public void tearDown() throws Exception {
		// Add additional tear down code here
	}

	/**
	 * Launch the test.
	 *
	 * @param args
	 *            the command line arguments
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	public static void main(final String[] args) {
		new org.junit.runner.JUnitCore().run(AnalysisResultLvl2aTest.class);
	}
}